#ifndef QWT_MATH_H
#define QWT_MATH_H

#include <math.h>

#define LOG10_2 	0.30102999566398119802  /* log10(2) */
#define LOG10_3 	0.47712125471966243540  /* log10(3) */
#define LOG10_5 	0.69897000433601885749  /* log10(5) */
#define M_2PI 		6.28318530717958623200  /* 2 pi */

#define LOG_MIN 1.0e-100
#define LOG_MAX 1.0e100


double qwtCeil125(double x);
double qwtFloor125(double x);
double qwtGetMin (double *array, int size);
double qwtGetMax( double *array, int size);
void qwtTwistArray(double *array, int size);
int qwtChkMono(double *array, int size);
void qwtLinSpace(double *array, int size, double xmin, double xmax);
void qwtLogSpace(double *array, int size, double xmin, double xmax);


template <class T>
inline const T& qwtMax (const T& x, const T& y) 
{
	return ( x > y ? x : y );
}

template <class T>
inline const T& qwtMin ( const T& x, const T& y)
{
	return ( x < y ? x : y );
}

template <class T>
inline const T& qwtAbs (const T& x)
{ return( x > T(0) ? x : x * T(-1) ); }


template <class T>
inline int qwtSign(const T& x)
{
	if (x > T(0))
	   return 1;
	else if (x < T(0))
	   return (-1);
	else
	   return 0;
}			 

template <class T>
inline T qwtSqr(const T&x)
{
	return x*x;
}

template <class T>
void qwtCopyArray(T *dest, T *src, int n) 
{
    int i;
    for (i=0; i<n;i++ )
       dest[i] = src[i];
}

template <class T>
void qwtSwap( T &x1, T& x2)
{
  T tmp;
  tmp = x1;
  x1 = x2;
  x2 = tmp;
}

#endif




