#ifndef QWT_SCLDIV_H
#define QWT_SCLDIV_H

#include <qarray.h>

class QwtScaleDiv
{
private:
    
    double d_lBound;
    double d_hBound;
    double d_majStep;
    bool d_log;


    QArray<double> d_majMarks;
    QArray<double> d_minMarks;

    void copy(const QwtScaleDiv &s);
    
public:

    QwtScaleDiv ();
    virtual ~QwtScaleDiv();
    QwtScaleDiv(const QwtScaleDiv& s);

    QwtScaleDiv& operator= (const QwtScaleDiv &s);
    int operator== (const QwtScaleDiv &s) const;
    int operator!= (const QwtScaleDiv &s) const;
    
    double lBound() const { return d_lBound; }
    double hBound() const { return d_hBound; }
    int minCnt() const { return d_minMarks.size(); }
    int majCnt() const { return d_majMarks.size(); }
    bool logScale() const { return d_log; }
    double majMark(int i) const { return d_majMarks[i]; }
    double minMark(int i) const { return d_minMarks[i]; }
    double majStep() const { return d_majStep; }
    void reset();

private:

    bool buildLinDiv(int maxMajMark, int maxMinMark, double step = 0.0, double ref=0.0);
    bool buildLogDiv(int maxMajMark, int maxMinMark, double step = 0.0, double ref=0.0);

public:

    bool rebuild(double lBound, double hBound, int maxMaj, int maxMin,
			 bool log, double step = 0.0, double ref = 0.0);
    
};

#endif
