// -*-c++-*-
#ifndef QWT_SLIDER_H
#define QWT_SLIDER_H

#include <qwt_sclif.h>
#include <qwt_sldbase.h>
#include <qwt_scldraw.h>
class QwtSlider : public QwtSliderBase, public QwtScaleIf
{
Q_OBJECT
     
 public:
	enum Orientation{Vertical, Horizontal};
	enum ScalePos {	None, Left, Right, Top, Bottom };
	
 private:

	QRect d_sliderRect;

	int d_thumbLength;
	int d_thumbHalf;
	int d_thumbWidth;
	int d_borderWidth;
	int d_scaleDist;
	int d_xMargin;
	int d_yMargin;
	
	int d_resized;
	bool d_autoResize;
	double d_scaleStep;

	Orientation d_orient;
	ScalePos d_scalePos;
	int markerPos;

 public:

	QwtSlider(QWidget *parent, const char *name = 0,
			Orientation orient = Horizontal, ScalePos scalePos = None);
	~QwtSlider();
	void setThumbLength(int l);
	void setThumbWidth(int w);
//	void setOrientation(Orientation o);
	void setBorderWidth(int bw);
//	void setMargins(int x, int y);
	
protected:

	virtual void drawSlider (QPainter *p, const QRect &r);
	double getValue(const QPoint &p);
	void getScrollMode( const QPoint &p, int &scrollMode, int &direction);
	void resizeEvent(QResizeEvent *e);
	void paintEvent (QPaintEvent *e);
	void valueChange();
	void rangeChange();
	void scaleChange();
	void fontChange();

private:
	void adjustMinSize();
	
};

#endif






