/***************************************************************************
                          btxtausschn.cpp  -  description
                             -------------------
    begin                : Tue Nov 30 1999
    copyright            : (C) 1999 by Heinz Schumann
    email                : heinz@bitana.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <kapp.h>
#include <qmessagebox.h>
#include <qdir.h>
#include <qfile.h>

#include "btxtausschn.h"
#include "bhebbuch.h"
#include "bhebidx.h"
#include "bgematria.h"
#include "bitana.h"

BTxtAusschn::BTxtAusschn()
{
 cod=new BHebBuch();
 gem=new BGematria();
 idx=new BHebIdx();
}

BTxtAusschn::~BTxtAusschn()
{
 delete gem;
 delete idx;
 delete cod;
}

bool BTxtAusschn::berText(QString buch, int bpos, int epos, int zbr)
{
 QFile a1, a2;
 bool ok;

// Open the files to write
 extern BitanaApp *bitana;

 QDir d=QDir::root();
 if (d.cd(bitana->getTmpDir())) a1.setName(d.filePath("aus1.lst"));
 else
 {
  QMessageBox::warning(0,i18n("Cannot find the working directory"),
                          bitana->getTmpDir());
  return FALSE;
 }
 a2.setName(d.filePath("aus2.lst"));

 if (!a1.open(IO_WriteOnly))
 {
   QMessageBox::warning(0,i18n("Cannot create the file"),
                         a1.name());
 }

 if (!a2.open(IO_WriteOnly))
 {
   QMessageBox::warning(0,i18n("Cannot create the file"),
                         a2.name());
 }


 QString tabstr;
 QString zeile;
 QString tmp;
 QTextStream tab(&a1);
 QTextStream lst(&a2);

// Control inputdata
 if((bpos+zbr)>epos)
 {
  switch (QMessageBox::information(0,i18n("Warning"),
                          i18n("Datasection to long\nsetting of correct length???"),
                          "&Yes","&No=Cancel", 0, 1))
   {
    case 0:
      zbr=epos-bpos;
      break;
    case 1: return FALSE;
   }
 }

// Headline for gematria table end textlines
 tab<<"# Tabelle"<<endl;
 lst<<"# Text"<<endl;
 lst<<"# "<<endl;
 tabstr=i18n("# \t8\tLine\t55\tLetter\t50\tAbsolute\t80\tRevers\t80\tReduced\t80\tOrdinal\t80\tSquared\t80\tAtbasch\t80");
 tab<<tabstr<<endl;
 tmp=buch.upper();
 tabstr=i18n("# Textshowing ");
 tab<<tabstr<<tmp;
 lst<<tabstr<<tmp;
 tabstr=i18n(" with line length ");
 tmp.setNum(zbr);
 tab<<tabstr<<tmp<<endl;
 lst<<tabstr<<tmp<<endl;
 tabstr=i18n("# From position ");
 tmp.setNum(bpos);
 tab<<tabstr<<tmp<<" (";
 lst<<tabstr<<tmp<<" (";
 idx->posKap(buch, bpos);
 tmp=idx->versdat.kapvers;
 tab<<tmp.left(6)<<")";
 lst<<tmp.left(6)<<")";
 tabstr=i18n(" to position ");
 tmp.setNum(epos);
 tab<<tabstr<<tmp<<" (";
 lst<<tabstr<<tmp<<" (";
 idx->posKap(buch, epos);
 tmp=idx->versdat.kapvers;
 tmp+=")";
 tab<<tmp.left(6)<<")"<<endl;
 lst<<tmp.left(6)<<")"<<endl;

// Read text and calculate sum gematria of line
 int z=zbr;
 int lfd=bpos;
 int i=0;
 while(lfd<epos)
 {
  i++;
  if(lfd+z>epos+1) z=epos-lfd+1;
  ok=cod->lesTextRevers(buch, lfd, z);
  if(!ok) return FALSE;
  if(z<zbr) cod->text=cod->text.rightJustify(zbr,' ');
  lst<<cod->text<<endl;
  gem->berGematria(cod->text);         // Calculate gematria
  tmp.setNum(i);
  tabstr=tmp;
  for(int k=1;k<8;k++)
  {
   tmp.setNum(gem->gemsum[k]);
   tabstr+=SEP+tmp;
  }
  tab<<tabstr<<endl;
  lfd=lfd+z;
 }

// Sum gematria of column
// tabstr=i18n("Spaltevonrechtsnachlinks   ");
 tabstr=i18n("Column\t(from\trigth\tto\tleft)\t \t \t ");
 tab<<tabstr<<endl;
 int p=0;
 uchar c;
 for(i=0;i<zbr;i++)
 {
  p=bpos+i;
  tabstr="";
  while(p<=epos)
  {
   c=cod->lesBuchst(buch,p);
   if(c==0) return FALSE;
   tabstr+=c;
   p=p+zbr;
  }
  gem->berGematria(tabstr);
  tabstr.setNum(i+1);
  for(int k=1;k<8;k++)
  {
   tmp.setNum(gem->gemsum[k]);
   tabstr+=SEP+tmp;
  }
  tab<<tabstr<<endl;
 }
 delete gem;
 delete idx;
 delete cod;
 return TRUE;
}

































































