#ifndef KDISPLAY_H 
#define KDISPLAY_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <kdevice.h>

#include <qwidget.h>
#include <qframe.h>
#include <qpntarry.h>
#include <qpoint.h>

#include <rfftw.h>

#define POINTS	1024

#define MAXMARKER	1
#define MARKER1		2
#define MARKER2		3
#define EXMARKER	4
#define KILLMARKER	5

enum { disabled = 0, drawing = 0x01, deleting = 0x02 };

typedef struct {
	int    flag;
	double fXVal;
	int    iXVal;
	double fYVal;
	int    iYVal;
} ptdata;

/****************************************************************/
/*																*/
/*							KScale								*/
/*																*/
/****************************************************************/

class KScale  : public QFrame
{
	Q_OBJECT
public:
	KScale (QWidget *parent = 0, const char *name = 0);
	virtual ~KScale ();
	
	void paintEvent(QPaintEvent*);
	
	void setFixedZeroLine(bool flag = TRUE, int zeroline = 0);
	void setXFmtString(char* fmt)			{ strcpy(chXFmt, fmt);
												strcpy(chFmt, chYFmt);
												strcat(chFmt, " ");
												strcat(chFmt, chXFmt);};
	void setYFmtString(char* fmt)			{ strcpy(chYFmt, fmt);
												strcpy(chFmt, chYFmt);
												strcat(chFmt, " ");
												strcat(chFmt, chXFmt);};
	void setXScale(float scale)				{ fXScale = scale; };
	void setYScale(float scale)				{ fYScale = scale; };

	void updateMarkers(ptdata*, ptdata*, ptdata*);
	void DrawMarkerValues(QPainter*, ptdata*, ptdata*, QRect, char*);
	
public slots:	

public:
	QFont f;
	char chXFmt[20];
	char chYFmt[20];
	char chFmt[40];
	int  iZeroLine;
	int  iStep;
	float	fXScale;
	float	fYScale;
	bool bAdaptiveZeroLine;
	
	char chMaxMarkerVal[50];
	char chMarker1Val[50];
	char chMarker2Val[50];
	char chDiffMarkerVal[50];
	ptdata ptMaxMarkerVal;
	ptdata ptMarker1Val;
	ptdata ptMarker2Val;
	ptdata ptDiffMarkerVal;
};

/****************************************************************/
/*																*/
/*							KDrawArea							*/
/*																*/
/****************************************************************/

class KDrawArea  : public QWidget
{
	Q_OBJECT
public:
	KDrawArea (QWidget *parent = 0, const char *name = 0);
	virtual ~KDrawArea ();

	void paintEvent(QPaintEvent*);
	void resizeEvent(QResizeEvent*);
	void mouseMoveEvent(QMouseEvent*);
	void mousePressEvent(QMouseEvent*);
	
	void setFixedZeroLine(bool flag = TRUE, int zeroline = -1);
	void setDrawWidth(int drawwidth = -1)		{ iDrawWidth = drawwidth; };
	void DrawGrid(QPainter*);	
//	void DrawData(short int* buf, int idx);
	void DrawData(double* buf, int);
	void DeleteContents(void);
	void DrawMarkers(QPainter*);
	void DeleteMarkers(QPainter*);
	void DeleteMarker1(QPainter*);
	void DeleteMarker2(QPainter*);

	void setXScale(float scale)				{ fXScale = scale; };
	void setYScale(float scale)				{ fYScale = scale; };

	int	 marker(int id, bool down);
		
public slots:	

public:
	int  iZeroLine;
	int  iStep;
	int  iDrawWidth;
	float	fXScale;
	float	fYScale;
	bool bAdaptiveZeroLine;
	
	int iActiveMarker;
	ptdata ptMaxMarkerVal;
	ptdata ptMarker1Val;
	ptdata ptMarker2Val;
};

/****************************************************************/
/*																*/
/*							KDisplay							*/
/*																*/
/****************************************************************/

class KDisplay  : public QWidget
{
	Q_OBJECT
public:
	KDisplay (QWidget *parent = 0, const char *name = 0);
	virtual ~KDisplay ();

	void paintEvent(QPaintEvent*);
	void resizeEvent(QResizeEvent*);
	void timerEvent(QTimerEvent*);

	int open(KDevice*);
	int close(void);
	
	void updateScales(void);
	int	 marker(int, bool);
	
	int TimeDomain(void);
	int FrequencyDomain(void);
	int DSP56FrequencyDomain(void);
	
public slots:	
	void trigger(bool);
	void fftdevice(bool);

public:
	KScale* 		pScale;
	KDrawArea* 		pDrawArea;
	KDevice*		pDevice;
	
    short int*      pPrevPtr;
	short int*      pCurrentPtr;
	short int*		pInvalidBufferPtr;
	short int*		pDeviceBuffer;

	// TimeDomain
	short int* pTriggerPosition;
	int iTriggerPoint;
	int iSlope;
	bool bFFTDevice;
	bool bTrigger;
	bool bTriggerPointFound;
	
	// FrequencyDomain
	fftw_real in[POINTS];
	fftw_real out[POINTS];
	fftw_real power_spectrum[POINTS];
	fftw_real win[POINTS];
	rfftw_plan p;
		
};

#endif // KDISPLAY_H 
 
