/*
 * ADAPT2D : a software for automatic mesh adaptation in 2D
 *
 * AUTHOR : Manuel J. Castro Diaz(e-mail:castro@gamba.cie.uma.es)
 * ADAPTED FOR FREEFEM : Prud'homme Christophe (e-mail:prudhomm@ann.jussieu.fr) 
 *
 * this code is public domain
 * 
 * You may copy freely these files and use it for    
 * teaching or research. These or part of these may   
 * not be sold or used for a commercial purpose without
 * our consent
 * 
 * Any problems should be reported to the AUTHOR
 * at the following address : castro@gamba.cie.uma.es
 */


#ifndef _aristaT1dlist_h
#define _aristaT1dlist_h

#include <a_t1.hxx>

class Frontera_T1;

   struct Arista_T1_dlink {
       Arista_T1* a;
       Arista_T1_dlink* suc;
       Arista_T1_dlink* prev;

       Arista_T1_dlink () {a=NIL; suc=NIL; prev=NIL;}
       Arista_T1_dlink (Arista_T1& ar, Arista_T1_dlink* ss,\
                        Arista_T1_dlink* pp)
            {a=&ar;suc=ss;prev=pp;}
       Arista_T1_dlink (Arista_T1* ar, Arista_T1_dlink* ss,\
                        Arista_T1_dlink* pp) {
             a=ar; suc=ss; prev=pp;} 

       void set (Arista_T1& ar, Arista_T1_dlink* ss, Arista_T1_dlink* pp)
                {a=&ar; suc=ss;prev=pp;}
       void set (Arista_T1* ar, Arista_T1_dlink* ss, Arista_T1_dlink* pp) {
                 a=ar; suc=ss; prev=pp;} 

       Arista_T1_dlink* sig() {return suc;}
       Arista_T1_dlink* ant() {return prev;}
       void operator delete (void* p) {
          Arista_T1* aux;
          if (p) {
            aux=((Arista_T1_dlink*)p)->a;
            if (aux) {delete aux; aux=NIL;}
            delete p;
            p=NIL;
          }
       }

    };

    class Arista_T1_dlist {

       Arista_T1_dlink* last;
       Arista_T1_dlink* begin;
       friend ostream& operator<<(ostream&, Arista_T1_dlist&);
   public:
       Arista_T1_dlist () {last=NIL; begin=NIL;}
       Arista_T1_dlist (Arista_T1_dlink* r) {last=begin=r;}
       void insert (Arista_T1_dlink* r) {//pega en cabeza de dlist
         if (r) {
           if (begin) {
               r->suc=begin;
               begin->prev=r;
               begin=r;

           }
           else {
               last=r;
               begin=r;
           }
         }
       }
       void append(Arista_T1_dlink* r) {//pega al final de dlist
         if (r) {
           if (last) {
              last->suc=r;
              r->prev=last;
              last=r;
           }
           else {
              last=r;
              begin=r;
           }
         }
       }
       void  enlaza (Arista_T1_dlist* rll) {  //une this+rll
        if (rll) {
          if (begin) {
           if (rll->begin) {
              last->suc=rll->begin;
              (rll->begin)->prev=last;
              last=rll->last;
              rll->begin=NIL;
              rll->last=NIL;
           }
          }
          else {
           begin=rll->begin;
           last=rll->last;
           rll->begin=NIL;
           rll->last=NIL;
          }
        }
   }
   void  enlaza (Arista_T1_dlist& rll) {  //une this+rll
        if (begin) {
           if (rll.begin) {
              last->suc=rll.begin;
              (rll.begin)->prev=last;
              last=rll.last;
              rll.begin=NIL;
              rll.last=NIL;
           }
        }
        else {
           begin=rll.begin;
           last=rll.last;
           rll.begin=NIL;
           rll.last=NIL;
       }

    }
    void kill (Arista_T1_dlink* r) { //elimina un elmento de la dlista
          if (r) {
           if (r==begin) {
              begin=r->suc;
              if (begin) begin->prev=NIL;
           }
           else {
             if (r==last) {
                last=r->prev;
                if (last) last->suc=NIL;
             }
             else {
               if (r->prev) (r->prev)->suc=r->suc;
               if (r->suc) (r->suc)->prev=r->prev;
             }
           }
           delete r;
          }
          r=NIL;
       }

       Arista_T1_dlink* principio () {return begin;}
       Arista_T1_dlink* fin () {return last;}
       int num_elem () {
           int num=0;
           Arista_T1_dlink* aux=begin;
           while (aux) {
            num++;
            aux=aux->suc;
           }
           return num;
       } 
       void clear () {
           Arista_T1_dlink* aux;
           while (begin) {
              aux=begin->suc;
              delete begin;
              begin=aux;
           }
           last=begin=NIL;
       }                             
       void operator delete (void* p){
         if (p) {
           ((Arista_T1_dlist*)p)->clear();
           delete p; p=NIL;
         }
       }
       void write (ostream&);
       Frontera_T1*  crea_frontera();

    };
#endif       
