/*
 * ADAPT2D : a software for automatic mesh adaptation in 2D
 *
 * AUTHOR : Manuel J. Castro Diaz(e-mail:castro@gamba.cie.uma.es)
 * ADAPTED FOR FREEFEM : Prud'homme Christophe (e-mail:prudhomm@ann.jussieu.fr)
 *
 * this code is public domain
 * 
 * You may copy freely these files and use it for    
 * teaching or research. These or part of these may   
 * not be sold or used for a commercial purpose without
 * our consent
 * 
 * Any problems should be reported to the AUTHOR
 * at the following address : castro@gamba.cie.uma.es
 */


/*    
      **********************************************************************
                       ADAPT2D   (version 1.0) 
                                                  
      **********************************************************************
       
*/


#include <adapt2d.hxx>

#if !defined(ADAPT)
int main() {
  Mallado_T0* malla;
  CAD* cad=NIL;
  Triangulation * t_cad=NIL,*t_ini=NIL,*t_fin;
  parameter param;
  Scalar* solution;
  Scalar** sol_interp=NIL;
  Scalar* tiempo;
  int err;

  malla=new Mallado_T0;
  t_cad=new Triangulation;
  t_ini=new Triangulation;
  cad=new CAD;
  sol_interp=new Scalar*;
  if (sol_interp==NIL) ERROR();
  if (malla==NIL || t_cad==NIL || t_ini==NIL || cad==NIL) ERROR();

#ifdef DEBUG
  cout<<"================================================="<<endl;
  cout<<"               READING PARAMETERS"<<endl;
  cout<<"================================================="<<endl;
#endif /* DEBUG */
  solution=read_param(t_cad, t_ini,param);
  malla->build(int(t_ini->np),int(t_ini->nt),t_ini->rp,t_ini->ng,t_ini->tr,t_ini->ngt);
  param.change(malla->factr());
  delete t_ini;

/*
 *       Metric generation from the solution using
 *                metrics intersection.
 *
 *     Also a boundary correction can be imposed when
 *              solving NS equations.
 * 
 *             Metric = |Hess solution|     
 * 
 */

  tiempo=new double;
  if (tiempo==NIL) ERROR();
  the_clock(tiempo);
#ifdef DEBUG
  cout<<"================================================="<<endl;
  cout<<"               METRIC COMPUTATION"<<endl;
  cout<<"================================================="<<endl;
#endif /* DEBUG */
  if (param.sol==1) {
    cal_metrica(malla,solution,malla->m,param.aniso,param.err0,param.lmax,param.lmin,param.nsol,param.refwall,param.hwall,malla->factr(),param.nbt_max);
#ifdef DEBUG_FILE
    escmtr2D(param.timtr,malla->m,malla->nbss(),malla->factr());
#endif /* DEBUG_FILE */
  }
  else {
    err=lecmtr(malla->m,param.timtr,malla->factr(),malla->nbss());
  }
#ifdef DEBUG
  the_clock(tiempo);
  cout<<"--------------------------------------------------------"<<endl;
  cout<<"Metric computation time :"<<*tiempo<<endl;
  cout<<"--------------------------------------------------------"<<endl;
#endif /* DEBUG */

  // CAD definition from t_cad.
  
  cad=build(t_cad,param.angulo,malla->factr());
  delete t_cad;
#ifdef DEBUG
  cout<<"================================================="<<endl;
  cout<<"                MESH ADAPTATION"<<endl;
  cout<<"================================================="<<endl;
#endif /* DEBUG */
  t_fin=regenera_malla(malla,solution,param.timesh,param.sol,param.nsol,param.sol_interp,param.angulo,param.nit,param.segur,tiempo,param.reg_ini,param.reg_fin,param.rel_mtr,param.fluid_NS,param.hwall,param.refwall,cad,param.tinterp,sol_interp);
  if (param.sol==1 && *sol_interp!=NIL) {
    strcat(param.sol_interp,".bb");
    escsol(int(t_fin->np),param.nsol,param.sol_interp,*sol_interp);
  }
  strcat(param.timesh,".am_fmt");
  t_fin->write(param.timesh);
#ifdef DEBUG
  the_clock(tiempo);
  cout<<"------------------------------------------------------------"<<endl;
  cout<<"Global time: Metric computation+mesh adaptation:"<<*tiempo<<endl;
  cout<<"------------------------------------------------------------"<<endl;
#endif /* DEBUG */

  if (param.sol==1 && solution!=NIL) delete[] solution;
  if (param.sol==1 && sol_interp!=NIL) {
    if (*sol_interp!=NIL) delete[] *sol_interp;
    delete sol_interp;
  }
  delete malla;
  delete cad;
  delete t_fin;

#ifdef DEBUG
  cout <<"NORMAL END OF ADAPT2D"<<endl;
#endif /* DEBUG */
}
#endif /* ADAPT */




