/*
 * ADAPT2D : a software for automatic mesh adaptation in 2D
 *
 * AUTHOR : Manuel J. Castro Diaz(e-mail:castro@gamba.cie.uma.es)
 * ADAPTED FOR FREEFEM : Prud'homme Christophe (e-mail:prudhomm@ann.jussieu.fr) 
 *
 * this code is public domain
 * 
 * You may copy freely these files and use it for    
 * teaching or research. These or part of these may   
 * not be sold or used for a commercial purpose without
 * our consent
 * 
 * Any problems should be reported to the AUTHOR
 * at the following address : castro@gamba.cie.uma.es
 */


#ifndef _aristaT1list_h
#define _aristaT1list_h

#include <a_t1.hxx>

  struct AristaT1_link {

     Arista_T1* a;
     AristaT1_link* suc;
    
     AristaT1_link () {a=NIL; suc=NIL;}
     AristaT1_link (Arista_T1* aa, AristaT1_link* nn) {a=aa; suc=nn;}
     AristaT1_link (Arista_T1& aa, AristaT1_link* nn) {a=&aa; suc=nn;}

     void set(Arista_T1* aa, AristaT1_link* nn) {a=aa; suc=nn;}
     void set(Arista_T1& aa, AristaT1_link* nn) {a=&aa; suc=nn;}
     AristaT1_link* sig () {return suc;}
     int operator<(AristaT1_link& aa)
      {return ((*a)<(*(aa.a)));}
  };
 

  class AristaT1_list {

     AristaT1_link* last;
     AristaT1_link* begin;
     
     friend ostream& operator<<(ostream&,  AristaT1_list& );
     
  public:
     AristaT1_list () {last=NIL;begin=NIL;}
     AristaT1_list (AristaT1_link* a) {last=begin=a;}
     void insert(AristaT1_link* a) {  //Pega a cabeza de lista.
             if (begin) {
               a->suc=begin;
               begin=a; 
             }
             else {
               last=a;
               begin=a;
             }
          }
     void append(AristaT1_link* a) {  //Pega al final de la lista.
             if (last) {
               last->suc=a;
               last=a;
             }
             else {
               last=a;
               begin=a;
             }
          }
     void enlaza(AristaT1_list& al) {  //une (this)+al
      if (begin) {
        if (al.begin) {
             last->suc=al.begin;
             last=al.last;
             al.begin=NIL;
             al.last=NIL;
        }
      }
      else {
        begin=al.begin;
        last=al.last;
        al.last=NIL;
        al.begin=NIL;
      }
     }
    void enlaza(AristaT1_list* al) {  //une (this)+al
      if (begin) {
        if (al->begin) {
             last->suc=al->begin;
             last=al->last;
             al->begin=NIL;
             al->last=NIL;
        }
      }
      else {
        begin=al->begin;
        last=al->last;
        al->begin=NIL;
        al->last=NIL;
      }
     }
     AristaT1_link* principio() {return begin;}         
     AristaT1_link* fin() {return last;}
     int num_elem() {
           int num=0;
           AristaT1_link* aux=begin;
              while (aux) {
                 num++;
                 aux=aux->suc;
              }
           return num;
         }

     int operator<(AristaT1_list& a)
      {return ((*last)<(*(a.begin)));}
     void clear() {
               AristaT1_link* aux;
               while(begin) {
                 aux=begin->suc;
                 delete begin; 
                 begin=aux;
               } 
            last=begin=NIL;
          }
     
     void operator delete (void* p)
      { 
        if (p) { 
          ((AristaT1_list*)p)->clear();
          delete p; p=NIL;
        }
      }              

    void write (ostream&);

 };

#endif
                           
