/*
 * ADAPT2D : a software for automatic mesh adaptation in 2D
 *
 * AUTHOR : Manuel J. Castro Diaz(e-mail:castro@gamba.cie.uma.es)
 * ADAPTED FOR FREEFEM : Prud'homme Christophe (e-mail:prudhomm@ann.jussieu.fr) 
 *
 * this code is public domain
 * 
 * You may copy freely these files and use it for    
 * teaching or research. These or part of these may   
 * not be sold or used for a commercial purpose without
 * our consent
 * 
 * Any problems should be reported to the AUTHOR
 * at the following address : castro@gamba.cie.uma.es
 */


#include <header.hxx>
#include <r2.hxx>

#ifndef ADAPT2D
#define refbdy 60
extern int tabref[refbdy][refbdy];
/* 
 *IMPORTANT REMARK. 
 *  refbdy is also defined in syntaxic.cxx. ATTENTION
 *  if you change it
 */
#endif /* ADAPT2D */


int indet(R2 c0,int ref0,int nb0,R2 c1,int ref1,int nb1) {

  int refa=0;

#if ADAPT2D
  refa=MIN(ref0,ref1);
#endif /* ADAPT2D */

#ifndef ADAPT2D
  refa = tabref[ref0][ref1];
  if (refa == 0)   refa=MIN(ref0,ref1);
#endif /* ADAPT2D */

#ifdef DEBUG
  cout<<endl;
  cout<<"----------------------------------------------------------"<<endl;
  cout<<"         Attention. Indetermination in edge reference"<<endl;
  cout<<"----------------------------------------------------------"<<endl;
  cout<<"Edge with vertices:"<<endl; 
  cout<<"v0:"<<setw(6)<<nb0<<"  ref.:"<<setw(2)<<ref0<<"   coor:"<<c0<<endl;
  cout<<"v1:"<<setw(6)<<nb1<<"  ref.:"<<setw(2)<<ref1<<"   coor:"<<c1<<endl;
  cout<<"Edge reference:"<<refa<<endl;
  cout<<"====================================================================="<<endl;
#endif /* DEBUG */  
/*
  while (refa<=0) {
  cout<<"referencia arista (refa >0):";
  cin>>refa;
  cout<<endl;
  }
  */
  return refa;
}
