/*
 * ADAPT2D : a software for automatic mesh adaptation in 2D
 *
 * AUTHOR : Manuel J. Castro Diaz(e-mail:castro@gamba.cie.uma.es)
 * ADAPTED FOR FREEFEM : Prud'homme Christophe (e-mail:prudhomm@ann.jussieu.fr) 
 *
 * this code is public domain
 * 
 * You may copy freely these files and use it for    
 * teaching or research. These or part of these may   
 * not be sold or used for a commercial purpose without
 * our consent
 * 
 * Any problems should be reported to the AUTHOR
 * at the following address : castro@gamba.cie.uma.es
 */


/*  **************************************************************************
                              LECSOL SUBROUTINE
    **************************************************************************

     Purpose: Input a file with a solution in format .bb
     -------      (P^1 interpolation)

     Input:   nombre_sol=File name.
     -----   
    

     Output:   * solucion = Field table with the solution at each node mesh. 
     ------
               nsol= Field dimension.

                Example:
               if (nsol==3) then 

               solucion[j*nsol+0]= first component of the field at vertex 'j'
               solucion[j*nsol+1]= Second component of the field at vertex 'j'
               solucion[j*nsol+2]= Third component of the field at vertex 'j'
     
     ************************************************************************
*/

#include <header.hxx>


Scalar*  lecsol(char* nombre_sol,int nbs0,int& nsol) {

  Scalar* solucion;
  int nbs;
  int i,j;
  
  
  OPENI(lectura, nombre_sol);
  lectura >>i>>nsol>>nbs>>j;   //  fiedl dimension and number of vertices.
  NEXTLINE(lectura);
  if (i!=3 || j!=2) {
    cerr<<"Sorry. Format not implemted. Only P^1 interpolation is impleted."<<endl;
    cerr<<"Error in subroutine lecsol.C"<<endl;
    exit(1);
  }
  
  if (nbs0!=nbs) {
    cerr<<"Error. Number of mesh vertices different from solution."<<endl;
    cerr<<"Error in subroutine lecsol.C"<<endl;
    exit(1);
  }
  
  solucion=new Scalar[nbs*nsol];
  if (solucion==NIL) ERROR();
  
  for (i=0; i<nbs; i++) {
    for (j=0; j<nsol; j++) {
      lectura >> solucion[nsol*i+j];
    }
  }
  
  lectura.close();
  
  
  return solucion;
  
}
