/*
 * ADAPT2D : a software for automatic mesh adaptation in 2D
 *
 * AUTHOR : Manuel J. Castro Diaz(e-mail:castro@gamba.cie.uma.es)
 * ADAPTED FOR FREEFEM : Prud'homme Christophe (e-mail:prudhomm@ann.jussieu.fr) 
 *
 * this code is public domain
 * 
 * You may copy freely these files and use it for    
 * teaching or research. These or part of these may   
 * not be sold or used for a commercial purpose without
 * our consent
 * 
 * Any problems should be reported to the AUTHOR
 * at the following address : castro@gamba.cie.uma.es
 */


#ifndef _malladoT1_h
#define _malladoT1_h

#include <v_t1_dl.hxx>
#include <a_t1_dl.hxx>
#include <t_t1_dl.hxx>
#include <m_t0.hxx>

typedef Triangulo_T1* p_Triangle;
typedef Vertice_T1* p_Sommet;
typedef Arista_T1*  p_Arete;

class Mallado_T1 {
public:
  Vertice_T1_dlist* Lsommet;
  Arista_T1_dlist* Larete;
  Triangulo_T1_dlist* Ltriangle;
  Scalar scale;

  Mallado_T1() {Lsommet=NIL; Larete=NIL; Ltriangle=NIL;}
  void build(Mallado_T0*);
  Triangulation* write();
  int write(char*);
  void clear() {
    if (Ltriangle) {
      Triangulo_T1_dlink* Lt_lk;
      Triangulo_T1* t0;
      Lt_lk=Ltriangle->principio();
      while (Lt_lk) {
        t0=Lt_lk->t;
        if (t0) {delete t0; t0=NIL;}
        Lt_lk=Lt_lk->sig();
      }
      if (Ltriangle) {delete Ltriangle; Ltriangle=NIL;}
      if (Larete) {delete Larete; Larete=NIL;}
      if (Lsommet) {delete Lsommet; Lsommet=NIL;}
    }
  }
  ~Mallado_T1() {this->clear();}
  void operator delete (void* p) {
    if (p) {
      ((Mallado_T1*)p)->clear();
      delete p; p=NIL;
    }
  }   
};

#endif
