/*
 * ADAPT2D : a software for automatic mesh adaptation in 2D
 *
 * AUTHOR : Manuel J. Castro Diaz(e-mail:castro@gamba.cie.uma.es)
 * ADAPTED FOR FREEFEM : Prud'homme Christophe (e-mail:prudhomm@ann.jussieu.fr) 
 *
 * this code is public domain
 * 
 * You may copy freely these files and use it for    
 * teaching or research. These or part of these may   
 * not be sold or used for a commercial purpose without
 * our consent
 * 
 * Any problems should be reported to the AUTHOR
 * at the following address : castro@gamba.cie.uma.es
 */


#ifndef _parameter_h
#define _parameter_h

#include <header.hxx>

class parameter{ 
  friend ostream& operator<<(ostream&,parameter&);   
public:
  Boolean sol;  //sol=1 there is an solution, 0 non solution.
  int     nsol; // number of parameters of the solution.
  char    timesh[72]; // file name of adapted mesh.
  char    timtr[72];  // metric file name.
  char    sol_interp[72]; // file name of interpolated solution
  int     tinterp;// type of interpolation operator (1-4)
  Scalar  scale;// mesh scale (computed from the mesh to be adapted)
/*
 *     Metric computation parameters
 */
  int     nbt_max; // Approximate number maximal of triangles to be generated 0= no impostion 
  Scalar  err0; // Tolerance error;
  Scalar  lmin; // Minimal edge length
  Scalar  lmax; // Maximal edge length
  Boolean aniso; // Mesh anisotropic ==1
  Scalar  hwall; // h in the normal direcction. 
  int     refwall; // node wall reference.
/*
 *    Mesh adaptation parameters
 */
  int     angulo; // angle for CAD definition. 
  int     nit; // number of iteration 0=default.
  Boolean segur; // copy of security at each iteration
  Boolean reg_ini; // initial regularization (swapping)
  Boolean reg_fin; // final regularization   
  Boolean rel_mtr;// metrix relaxation.
  Boolean fluid_NS; // hard imposition of wall condition.
  parameter() {
    strcpy(timesh,"");strcpy(timtr,"");strcpy(sol_interp,"");
    sol=TRUE; nsol=1;tinterp=4;scale=1.0; nbt_max=0;
    err0=1e-2; lmin=1e-2; lmax=2.0; aniso=TRUE;
    hwall=1e-2; refwall=3; angulo=15; nit=0; segur=FALSE; reg_ini=TRUE;
    reg_fin=TRUE; rel_mtr=FALSE; fluid_NS=FALSE;
  }
  void write(ostream&);
  void change(Scalar);
};                  


#endif
