/*
 * ADAPT2D : a software for automatic mesh adaptation in 2D
 *
 * AUTHOR : Manuel J. Castro Diaz(e-mail:castro@gamba.cie.uma.es)
 * ADAPTED FOR FREEFEM : Prud'homme Christophe (e-mail:prudhomm@ann.jussieu.fr) 
 *
 * this code is public domain
 * 
 * You may copy freely these files and use it for    
 * teaching or research. These or part of these may   
 * not be sold or used for a commercial purpose without
 * our consent
 * 
 * Any problems should be reported to the AUTHOR
 * at the following address : castro@gamba.cie.uma.es
 */


#ifndef _trianguloT0_h
#define _trianguloT0_h

#include <header.hxx>
#include <v_t0.hxx>
#include <a_t0.hxx>
#include <r2.hxx>
#include <metric.hxx>

class Triangulo_T0{ 
      friend ostream& operator<<(ostream&, Triangulo_T0&);
   public:
      Vertice_T0*    s[3];   // Punteros sobre los vertices del triangulo.
      Triangulo_T0*  t[3];   // Punteros sobre los triangulos adyacentes.
      Arista_T0*     a[3];   // Punteros sobre las aristas del triangulo.
      int             ref;   // Referencia del triangulo.
      long int      marca;

      Triangulo_T0 ();
      Triangulo_T0 (Vertice_T0*, Vertice_T0*, Vertice_T0*,\
                    Triangulo_T0*, Triangulo_T0*, Triangulo_T0*,\
                    Arista_T0*, Arista_T0*, Arista_T0*, int); 
      Triangulo_T0 (Vertice_T0&, Vertice_T0&, Vertice_T0&,\
                    Triangulo_T0&, Triangulo_T0&, Triangulo_T0&,\
                    Arista_T0&, Arista_T0&, Arista_T0&, int);
      Triangulo_T0 (Vertice_T0*[], Triangulo_T0*[], Arista_T0*[], int);
      Triangulo_T0 (const Triangulo_T0&); 
      void write(ostream&);
      void set (Vertice_T0*, Vertice_T0*, Vertice_T0*,\
                Triangulo_T0*, Triangulo_T0*, Triangulo_T0*,\
                Arista_T0*, Arista_T0*, Arista_T0*, int); 
      void set (Vertice_T0&, Vertice_T0&, Vertice_T0&,\
                Triangulo_T0&, Triangulo_T0&, Triangulo_T0&,\
                Arista_T0&, Arista_T0&, Arista_T0&, int); 
      void set (Vertice_T0*[], Triangulo_T0*[], Arista_T0*[], int);
      void set (const Triangulo_T0&);
      Triangulo_T0& operator=(const Triangulo_T0&);
      R2 coor_bar(const R2&);
      int arista(Vertice_T0*,Vertice_T0*);
      int arista(Arista_T0*);
      int sommet(Vertice_T0*);
      int sommet_sig(Vertice_T0*);
      Triangulo_T0* vecino(Vertice_T0*, int);
      Scalar area();
      Scalar area2D();
      Metrica metrica();
      friend Scalar d_triangle(Triangulo_T0,const R2&,\
                  R2&); 
      friend Triangulo_T0* triangle_sig(Triangulo_T0*,const R2&,\
                  R2&,Scalar&,Arista_T0&);

};                  

#endif
