/*
 * ADAPT2D : a software for automatic mesh adaptation in 2D
 *
 * AUTHOR : Manuel J. Castro Diaz(e-mail:castro@gamba.cie.uma.es)
 * ADAPTED FOR FREEFEM : Prud'homme Christophe (e-mail:prudhomm@ann.jussieu.fr)
 *
 * this code is public domain
 * 
 * You may copy freely these files and use it for    
 * teaching or research. These or part of these may   
 * not be sold or used for a commercial purpose without
 * our consent
 * 
 * Any problems should be reported to the AUTHOR
 * at the following address : castro@gamba.cie.uma.es
 */


#ifndef _trianguloT1_h
#define _trianguloT1_h

#include <header.hxx>
#include <v_t1.hxx>
#include <a_t1.hxx>
#include <r2.hxx>
#include <metric.hxx>
 
struct Triangulo_T1_dlink;

class Triangulo_T1{ 
  friend ostream& operator<<(ostream&, Triangulo_T1&);
public:
  Vertice_T1*    s[3];   // Punteros sobre los vertices del triangulo.
  Triangulo_T1*  t[3];   // Punteros sobre los triangulos adyacentes.
  Arista_T1*     a[3];   // Punteros sobre las aristas.
  int             ref;   // Rerefencias del triangulo.
                         // Otros datos. 
  Scalar              krit;   // valor del criterio en este triangulo.
  Triangulo_T1_dlink*   lk;   // link de que lo contiene en la dlista.
  Triangulo_T1_dlink*  lk0;   // link de la lista local que lo contiene.

  Triangulo_T1 ();
  Triangulo_T1 (Vertice_T1*, Vertice_T1*, Vertice_T1*,\
		Triangulo_T1*, Triangulo_T1*, Triangulo_T1*,\
		Arista_T1*, Arista_T1*, Arista_T1*, int); 
  Triangulo_T1 (Vertice_T1&, Vertice_T1&, Vertice_T1&,\
		Triangulo_T1&, Triangulo_T1&, Triangulo_T1&,\
		Arista_T1&, Arista_T1&, Arista_T1&, int);
  Triangulo_T1 (Vertice_T1*[], Triangulo_T1*[], Arista_T1*[], int);
  Triangulo_T1 (const Triangulo_T1&); 
  void write(ostream&);
  void set (Vertice_T1*, Vertice_T1*, Vertice_T1*,\
	    Triangulo_T1*, Triangulo_T1*, Triangulo_T1*,\
	    Arista_T1*, Arista_T1*, Arista_T1*, int); 
  void set (Vertice_T1&, Vertice_T1&, Vertice_T1&,\
	    Triangulo_T1&, Triangulo_T1&, Triangulo_T1&,\
	    Arista_T1&, Arista_T1&, Arista_T1&, int); 
  void set (Vertice_T1*[], Triangulo_T1*[], Arista_T1*[], int);
  void set (const Triangulo_T1&);
  void set_lk(Triangulo_T1_dlink* llk) {lk=llk;}
  Triangulo_T1& operator=(const Triangulo_T1&);
  R2 coor_bar( const R2&);
  int arista(Vertice_T1*,Vertice_T1*);
  int arista(Arista_T1*);
  int arista0(Vertice_T1*,Vertice_T1*);
  int arista0(Arista_T1*);
  int sommet(Vertice_T1*);
  int sommet0(Vertice_T1*);
  int sommet_sig(Vertice_T1*);
  Triangulo_T1* vecino(Vertice_T1*, int);
  R2 altura(int);
  Scalar hk();
  Scalar area();
  Scalar area2D();
  Arista_T1* supr_arista(int&);
};                  

#endif

