/*
 * ADAPT2D : a software for automatic mesh adaptation in 2D
 *
 * AUTHOR : Manuel J. Castro Diaz(e-mail:castro@gamba.cie.uma.es)
 * ADAPTED FOR FREEFEM : Prud'homme Christophe (e-mail:prudhomm@ann.jussieu.fr) 
 *
 * this code is public domain
 * 
 * You may copy freely these files and use it for    
 * teaching or research. These or part of these may   
 * not be sold or used for a commercial purpose without
 * our consent
 * 
 * Any problems should be reported to the AUTHOR
 * at the following address : castro@gamba.cie.uma.es
 */


#ifndef _verticeT0_h
#define _verticeT0_h

#include <header.hxx>
#include <r2.hxx>

class Metrica;
class Triangulo_T0;

class Vertice_T0 {
    friend ostream& operator<<(ostream&, Vertice_T0&);
  public:
    R2            c;  // coordenadas.
    Boolean   front;  // TRUE si esta en la frontera.
    int         ref;  // referencia.
    Triangulo_T0* t;  // Un triangulo que lo contiene.
    Metrica*      m;  // Metrica en dicho nodo.

    Vertice_T0 (): c(),ref(0) {t=NIL;m=NIL;front=FALSE;}
    Vertice_T0 (Scalar xx, Scalar yy, int reff=0):\
                c(xx,yy),ref(reff){ t=NIL;m=NIL;front=FALSE;}
    Vertice_T0 (const R2& cc, int reff):c(cc),ref(reff){t=NIL;m=NIL;front=FALSE;}
    Vertice_T0 (const R2&cc, int reff,Triangulo_T0* tt, Metrica* mm):\
                c(cc),ref(reff) {t=tt;m=mm;front=FALSE;}
    Vertice_T0 (const Vertice_T0& ss): c(ss.c),ref(ss.ref) {t=ss.t;m=ss.m;front=ss.front;}

    void write(ostream&);

    void set (const R2& cc, int reff) {
       c=cc;ref=reff;
       front=FALSE;
       t=NIL;
       m=NIL;}
    void set (Scalar xx, Scalar yy, int reff) {
       c.set(xx,yy);
       ref=reff;
       front=FALSE;
       t=NIL;
       m=NIL;}
    void set (const Vertice_T0& ss){
       c=ss.c;
       ref=ss.ref;
       front=ss.front;
       t=ss.t;
       m=ss.m;}
    void set (const R2& cc,int reff,Triangulo_T0* tt,\
              Metrica* mm) {
       c=cc;
       ref=reff;
       front=FALSE;
       t=tt;
       m=mm;}
    void set (const R2& cc,int reff,Triangulo_T0* tt) {
       c=cc;
       ref=reff;
       front=FALSE;
       t=tt;
       m=NIL;
    }

    int operator==(const Vertice_T0& ss) {
        int v=0;
        if (c==ss.c) v=1;
        return v;
    }

    Vertice_T0& operator=(const Vertice_T0& ss) {
                          c=ss.c;
                          ref=ss.ref;
                          front=ss.front;
                          t=ss.t;
                          m=ss.m;
                          return *this;
               }


};


#endif

