;;!emacs
;;
;; LCD-ENTRY:    Pkg-Name|Author|Contact|Description|Date|Version|ftp location
;;
;; FILE:         gfem.el
;; SUMMARY:      a mode for the gfem Language
;; USAGE:        GNU/X Emacs Lisp Library
;; KEYWORDS:     
;;
;; AUTHOR:       Christophe Prud'homme
;; ORG:           
;; E-MAIL:       Christophe.Prudhomme@asci.fr
;;
;; ORIG-DATE:     8-Feb-97 at 14:24:14
;; LAST-MOD:      8-Feb-97 at 15:20:03 by Christophe Prud'homme
;;
;; Copyright (C) 1997 Christophe Prud'homme
;;
;; DESCRIPTION:  
;; DESCRIP-END.

;;; ************************************************************************
;;; Other required Elisp libraries
;;; ************************************************************************

;;; ************************************************************************
;;; Public variables
;;; ************************************************************************
;;; Portability stuff:
(defsubst gfem-xemacs-p ()
  (string-match "XEmacs\\|Lucid" emacs-version))

(defvar del-back-ch (car (append (where-is-internal 'delete-backward-char)
				 (where-is-internal 'backward-delete-char-untabify)))
  "Character generated by key bound to delete-backward-char.")

(and (vectorp del-back-ch) (= (length del-back-ch) 1) 
     (setq del-back-ch (aref del-back-ch 0)))

(if (gfem-xemacs-p)
    (progn
      ;; "Active regions" are on: use region only if active
      ;; "Active regions" are off: use region unconditionally
      (defun gfem-use-region-p ()
	(if zmacs-regions (mark) t))
      (defun gfem-mark-active () (mark)))
  (defun gfem-use-region-p ()
    (if transient-mark-mode mark-active t))
  (defun gfem-mark-active () mark-active))

(defsubst gfem-enable-font-lock ()
  (or (gfem-xemacs-p) window-system))

(if (boundp 'unread-command-events)
    (if (gfem-xemacs-p)
	(defun gfem-putback-char (c)	; XEmacs >= 19.12
	  (setq unread-command-events (list (character-to-event c))))
      (defun gfem-putback-char (c)	; Emacs 19
	(setq unread-command-events (list c))))
  (defun gfem-putback-char (c)		; XEmacs <= 19.11
    (setq unread-command-event (character-to-event c))))

(or (fboundp 'uncomment-region)
    (defun uncomment-region (beg end)
      (interactive "r")
      (comment-region beg end -1)))

(defvar gfem-do-not-fontify
  (if (string< emacs-version "19.30")
      'fontified
    'lazy-lock)
  "Text property which inhibits refontification.")

(if (or (string-match "XEmacs\\|Lucid" emacs-version)
	window-system)
    (require 'font-lock))

;; The default extension is .pde
(setq auto-mode-alist
      (append '(
		("\\.[pP][dD][eE]$" . gfem-mode))  
	      auto-mode-alist ))


(defvar gfem-font-lock-keywords-1 nil
  "Additional expressions to highlight in Gfem mode. Minimal set.")
(defvar gfem-font-lock-keywords nil
  "Additional expressions to highlight in Gfem mode. Default set.")
(defvar gfem-font-lock-keywords-2 nil
  "Additional expressions to highlight in Gfem mode. Maximal set")

;;; ************************************************************************
;;; Public functions
;;; ************************************************************************
(defun gfem-mode ()
  "Major mode for editing Gfem code. This is musch
like the c-mode except." 
  (interactive) 
  (kill-all-local-variables)
  (require 'cc-mode)
  (use-local-map c-mode-map)
  (c-common-init)
  (set-syntax-table c-mode-syntax-table)

  (setq major-mode 'gfem-mode)
  (setq mode-name "Gfem")

  (set-syntax-table gfem-mode-syntax-table)
  (make-local-variable 'indent-line-function)
  (setq indent-line-function 'c-indent-line)

  (make-local-variable 'comment-start)

  (make-local-variable 'comment-end)
  (setq comment-start "/* "
	comment-end   " */"
	comment-multi-line t
	c-comment-start-regexp c-C-comment-start-regexp)

  (make-local-variable 'comment-indent-function)
  (setq comment-indent-function 'c-comment-indent)
  (run-hooks 'gfem-mode-hook)
  )



;;; ************************************************************************
;;; Private functions
;;; ************************************************************************
(defvar gfem-keywords '("border" "buildmesh" "solve" "if" "then" "else" "pde" "plot"
			"wait" "nowait" "changewait" "varsolve"))

(defconst gfem-font-lock-keywords
      (list
       ;; Fontify [[ ]] expressions
       '("\\(\\[.*\\]\\)"  1 font-lock-doc-string-face t)
       ;; Fontify keywords
       (cons (concat
	      "\\(\\<"
	      (mapconcat 'identity gfem-keywords "\\>\\|\\<")
	      "\\>\\)")
	     1)
       ;; Fontify function names
       '("\\<function[ \t]+\\([^(; \t]+\\)" 1 font-lock-function-name-face)
       '("\\(^[ \t]*[A-Za-z_][A-Za-z_0-9]*[ \t]*()\\)" 1 font-lock-function-name-face)
       ))

(put 'gfem-mode	'font-lock-keywords 'gfem-font-lock-keywords)
;;; ************************************************************************
;;; Private variables
;;; ************************************************************************
