// -*- Mode: c++ -*-
//
// $Id$
//
// SUMMARY:      
// USAGE:        
//
// AUTHOR:       Christophe Prud'homme
// ORG:          Christophe Prud'homme company
// E-MAIL:       Christophe.Prudhomme@asci.fr
//
// ORIG-DATE:    10-Sep-97 at 23:34:33
// LAST-MOD:     14-Sep-97 at 22:48:04 by Christophe Prud'homme
//
// DESCRIPTION:  
//
// $Log$
// DESCRIP-END.
//
#if defined(__GNUG__)
#pragma implementation
#endif /* __GNUG__ */

/*
 * this is for HP workstations
 * this allow to avoid including setjmp.h
 *
 * SEE THE FUNCTION ERREUR (INT)
 */
#if ( defined (__hp9000s700) )
# ifdef __cplusplus
extern "C" {
# endif /* __cplusplus */
# define _JBLEN 50
  typedef double jmp_buf[_JBLEN/2];
  extern void longjmp (jmp_buf,int);
  extern int setjmp (jmp_buf);
# ifdef __cplusplus
}
# endif /* __cplusplus */
#else /* not __hp9000s700 */
# include <setjmp.h>
#endif /* defined (__hp9000s700) */
 





#include <qwidget.h>

#include <GFem.h>
#include <triangul.h>
#include <opclass.h> 
#include <lexical.h> 
#include <syntaxic.h>

extern jmp_buf context;
extern void parse (const char *); 
extern int NumOfIterations,Iter;
extern triangulation t;
extern float xfmin, xfmax;

typedef enum {
  NO_MESSAGE=-2,
  STOP = -1,
  ERROR = 0,
  MESH = 1,
  FUNCTION = 2
} compil_msg;
extern compil_msg cmsg;

void 
GFem::run()
{
  if (setjmp (context) == 0)
    {
      parse ( (const char*)(*edp)); 
      
      /* 
       * Freeing the triangulation
       */
      delete [] t.rp;
      delete [] t.tr;
      delete [] t.ng;
      delete [] t.ngt;
      
    }
  else
    {
      switch (cmsg)
	{
	case ERROR:
	  //printf ("FreeFEM: an error has occured.\n");
	  break;
	case STOP:
	  //printf ("FreeFEM: simulation stopped (right button pressed)\n");
	  break;
	}
    }
}
