#include "xyplot.h"

#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>

#include "debug.h"
#include "plot.h"
#include "kpen.h"
#include "worksheet.h"

#include <kcolorbtn.h>
#include <kfontdialog.h>
#include <kcolordlg.h>
#include <ktablistbox.h>
#include <kiconloader.h>


#define MSG(string) string


static int max (int a, int b)
{
  return (a > b ? a : b);
}

//static const char* qcolor (const QColor& color)
//{
//  static char buffer [64];
//  sprintf(buffer,"rgb=%2x%2x%2x",color.red(),color.green(),color.blue());
//  return buffer;
//}


/*
 * Implementation of XYPlot Tick/Subtick widget
 *
 */

XYPlotTickModeWidget::XYPlotTickModeWidget (QWidget* parent, const char* name)
  : QWidget(parent,name)
{
  rb_auto = new QRadioButton(this,"radio-auto");
  rb_auto->setGeometry(0,0,100,25);
  rb_auto->setText("auto");
  rb_auto->setAutoRepeat(FALSE);
  rb_auto->setAutoResize(FALSE);

  rb_size = new QRadioButton(this,"radio-size");
  rb_size->setGeometry(0,30,80,25);
  rb_size->setText("step size:");
  rb_size->setAutoRepeat(FALSE);
  rb_size->setAutoResize(FALSE);

  rb_step = new QRadioButton(this,"radio-step");
  rb_step->setGeometry(0,60,80,25);
  rb_step->setText("# of steps:");
  rb_step->setAutoRepeat(FALSE);
  rb_step->setAutoResize(FALSE);

  le_size = new QLineEdit(this,"lined-size");
  le_size->setGeometry(90,30,80,25);
  le_size->setText("");
  le_size->setMaxLength(32);
  le_size->setEchoMode(QLineEdit::Normal);
  le_size->setFrame(TRUE);
  le_size->setEnabled(FALSE);

  le_step = new QLineEdit(this,"lined-step");
  le_step->setGeometry(90,60,80,25);
  le_step->setText("");
  le_step->setMaxLength(32);
  le_step->setEchoMode(QLineEdit::Normal);
  le_step->setFrame(TRUE);
  le_step->setEnabled(FALSE);
  
  group = new QButtonGroup(this,"group-tick");
  group->setGeometry(0,0,170,85);
  group->setAlignment(1);
  group->insert(rb_auto);
  group->insert(rb_size);
  group->insert(rb_step);
  group->lower();
  group->hide();
  connect(group,SIGNAL(clicked(int)),SLOT(triggered(int)));

  setFixedSize(170,85);
}


XYPlotTickModeWidget::~XYPlotTickModeWidget ()
{
  delete group;
  group = 0; // paranoia setting
  delete le_size;
  le_size = 0;
  delete le_step;
  le_step = 0;
}


void XYPlotTickModeWidget::triggered (int state)
{
  switch(state) {
  case 0:
	le_size->setEnabled(FALSE);
	le_step->setEnabled(FALSE);
	break;
  case 1:
	le_size->setEnabled(TRUE);
	le_step->setEnabled(FALSE);
	le_size->setFocus();
	break;
  case 2:
	le_size->setEnabled(FALSE);
	le_step->setEnabled(TRUE);
	le_step->setFocus();
	break;
  default:
	cout << "XYPlotTickWidget::triggered(): State of Euphoria!" << endl;
  }
}


void XYPlotTickModeWidget::setState (int mode, double size, int step)
{
  char buffer [128];
  sprintf(buffer,"%f",size);
  le_size->setText(buffer);
  sprintf(buffer,"%i",step);
  le_step->setText(buffer);
  switch(mode%3) {
  case 0:
	rb_auto->setChecked(TRUE);
	rb_size->setChecked(FALSE);
	rb_step->setChecked(FALSE);
	break;
  case 1:
	rb_auto->setChecked(FALSE);
	rb_size->setChecked(TRUE);
	rb_step->setChecked(FALSE);
	break;
  case 2:
	rb_auto->setChecked(FALSE);
	rb_size->setChecked(FALSE);
	rb_step->setChecked(TRUE);
	break;
  }
  triggered(mode%3);
}


void XYPlotTickModeWidget::state (int& mode, double& size, int& step)
{
  size = atof(le_size->text());
  step = atoi(le_step->text());
  mode = 0;
  if (rb_size->isChecked())
	mode = 1;
  if (rb_step->isChecked())
	mode = 2;
}


/*
 * Implementation of XYPlot full tick widget
 *
 */

XYPlotTickWidget::XYPlotTickWidget (QWidget* parent, const char* name)
  : QWidget(parent,name)
{
  int flags;
  int x = 0;
  int y = 10;

  tick_w = new XYPlotTickModeWidget(this,"widget-tickmode");
  tick_w->move(10,y);
  x = max(x,10+tick_w->width());
  y += tick_w->height() + 10;

  flags = KPenWidget::KPen_style | KPenWidget::KPen_width
	| KPenWidget::KPen_color | KPenWidget::KPen_example;
  tick_pen_w = new KPenWidget(flags,this,"widget-tickpen");
  tick_pen_w->move(10,y);
  x = max(x,10+tick_pen_w->width());
  y += tick_pen_w->height() + 10;

  len_label_w = new QLabel(this,"label-len");
  len_label_w->setGeometry(10,y,60,25);
  len_label_w->setText("Length:");
  tick_len_w = new QSlider(0,10,1,0,QSlider::Horizontal,this,"slider-len");
  tick_len_w->setGeometry(80,y,100,25);
  x = max(x,180);
  y += 35;

  grid_w = new QCheckBox("show grid",this,"check-grid");
  grid_w->setGeometry(10,y,100,25);
  connect(grid_w,SIGNAL(clicked()),SLOT(toggleGrid()));
  grid_pen_w = new KPenButton(this,"button-pen");
  grid_pen_w->setGeometry(120,y,80,25);
  x = max(x,200);
  y += 25;

  setFixedSize(x,y);
}


XYPlotTickWidget::~XYPlotTickWidget ()
{
  delete tick_w;
  tick_w = 0;
  delete tick_len_w;
  tick_len_w = 0;
  delete tick_pen_w;
  tick_pen_w = 0;
  delete grid_w;
  grid_w = 0;
  delete grid_pen_w;
  grid_pen_w = 0;
  delete len_label_w;
  len_label_w = 0;
}


void XYPlotTickWidget::toggleGrid ()
{
  if (grid_w->isChecked())
	grid_pen_w->setEnabled(TRUE);
  else
	grid_pen_w->setEnabled(FALSE);
}


void XYPlotTickWidget::setState (const XYPlotTickState& s)
{
  tick_w->setState(s.mode,s.size,s.steps);
  tick_len_w->setValue(s.tick_len);
  grid_w->setChecked(s.grid);
  grid_pen_w->setPen(s.grid_pen);
  tick_pen_w->setPen(s.tick_pen);
}


void XYPlotTickWidget::state (XYPlotTickState& s)
{
  tick_w->state(s.mode,s.size,s.steps);
  s.tick_len = tick_len_w->value();
  s.grid = grid_w->isChecked();
  s.grid_pen = grid_pen_w->pen();
  s.tick_pen = tick_pen_w->pen();
}


/*
 * Implementation of XYPlot axis label widget
 *
 */

XYPlotAxisLabelWidget::XYPlotAxisLabelWidget (QWidget* parent, 
											  const char* name)
  : QWidget(parent,name)
{
  int i;
  font_w = new QPushButton("Font",this,"button-font");
  font_w->setGeometry(0,0,80,25);
  connect(font_w,SIGNAL(clicked()),SLOT(clickedFont()));
  color_w = new KColorButton(this,"button-color");
  color_w->setGeometry(100,0,80,25);
  fmt_label = new QLabel("Format:",this,"label-fmt");
  fmt_label->setGeometry(0,30,100,25);
  fmt_w = new QComboBox(this,"combo-fmt");
  fmt_w->setGeometry(110,30,90,25);
  for (i=0; i<(int)XYPlotFormatList().count(); i++)
	fmt_w->insertItem(XYPlotFormatList().at(i)->name);

  setFixedSize(200,55);
}


XYPlotAxisLabelWidget::~XYPlotAxisLabelWidget ()
{
  delete fmt_label;
  fmt_label = 0;
  delete font_w;
  font_w = 0;
  delete color_w;
  color_w = 0;
  delete fmt_w;
  fmt_w = 0;
}


void XYPlotAxisLabelWidget::clickedFont ()
{
  KFontDialog::getFont(the_font);
}


void XYPlotAxisLabelWidget::setState (const QFont& f, const QColor& c, int fm)
{
  the_font = f;
  color_w->setColor(c);
  fmt_w->setCurrentItem(fm);
}

void XYPlotAxisLabelWidget::state (QFont& f, QColor& c, int& fm)
{
  f = the_font;
  c = color_w->color();
  fm = fmt_w->currentItem();
}


/*
 * Implementation of XYPlot range widget
 *
 */

XYPlotRangeWidget::XYPlotRangeWidget (QWidget* parent, const char* name)
  : QWidget(parent,name)
{
  rb_auto = new QRadioButton(this,"radio-auto");
  rb_auto->setGeometry(0,0,100,25);
  rb_auto->setText("auto");
  rb_auto->setAutoRepeat(FALSE);
  rb_auto->setAutoResize(FALSE);

  rb_fixed = new QRadioButton(this,"radio-fixed");
  rb_fixed->setGeometry(0,30,80,25);
  rb_fixed->setText("fixed from");
  rb_fixed->setAutoRepeat(FALSE);
  rb_fixed->setAutoResize(FALSE);

  le_from = new QLineEdit(this,"lined-from");
  le_from->setGeometry(90,30,80,25);
  le_from->setText("");
  le_from->setMaxLength(32);
  le_from->setEchoMode(QLineEdit::Normal);
  le_from->setFrame(TRUE);
  le_from->setEnabled(FALSE);

  le_to = new QLineEdit(this,"lined-to");
  le_to->setGeometry(90,60,80,25);
  le_to->setText("");
  le_to->setMaxLength(32);
  le_to->setEchoMode(QLineEdit::Normal);
  le_to->setFrame(TRUE);
  le_to->setEnabled(FALSE);

  lb_to = new QLabel(this,"label-to");
  lb_to->setGeometry(60,60,20,25);
  lb_to->setText("to");

  group = new QButtonGroup(this,"group-range");
  group->setGeometry(0,0,170,85);
  group->setAlignment(1);
  group->insert(rb_auto);
  group->insert(rb_fixed);
  group->lower();
  group->hide();
  connect(group,SIGNAL(clicked(int)),SLOT(triggered(int)));

  setFixedSize(170,85);
}


XYPlotRangeWidget::~XYPlotRangeWidget ()
{
  delete group;
  group = 0; // paranoia setting
  delete le_from;
  le_from = 0;
  delete le_to;
  le_to = 0;
  delete lb_to;
  lb_to = 0;
}


void XYPlotRangeWidget::triggered (int state)
{
  switch(state) {
  case 0:
	le_from->setEnabled(FALSE);
	le_to->setEnabled(FALSE);
	break;
  case 1:
	le_from->setEnabled(TRUE);
	le_to->setEnabled(TRUE);
	le_from->setFocus();
	break;
  default:
	cout << "XYPlotRangeWidget::triggered(): State of Euphoria!" << endl;
  }
}


void XYPlotRangeWidget::setState (int mode, double from, double to)
{
  char buffer [128];
  sprintf(buffer,"%f",from);
  le_from->setText(buffer);
  sprintf(buffer,"%f",to);
  le_to->setText(buffer);
  switch(mode%3) {
  case 0:
	rb_auto->setChecked(TRUE);
	rb_fixed->setChecked(FALSE);
	break;
  case 1:
	rb_auto->setChecked(FALSE);
	rb_fixed->setChecked(TRUE);
	break;
  }
  triggered(mode%3);
}


void XYPlotRangeWidget::state (int& mode, double& from, double& to)
{
  from = atof(le_from->text());
  to = atof(le_to->text());
  mode = 0;
  if (rb_fixed->isChecked())
	mode = 1;
}


/*
 * Implementation of XYPlot Label and Range widget.
 * Just combine the XYPlotRangeWidget and XYPlotAxisLabelWidget
 * to one widget, which is part of a tab dialog. Oh yeah, and
 * add checkboxes for zero line and labels at zero.
 *
 */

XYPlotLabelRangeWidget::XYPlotLabelRangeWidget (QWidget* parent,
												const char* name)
  : QWidget(parent,name)
{
  int y = 0;
  QLabel* label;

  label = new QLabel("Range",this,"label-range");
  label->setGeometry(10,y,100,25);
  range = new XYPlotRangeWidget(this,"widget-range");
  range->move(70,y);
  y += 10 + range->height();

  label = new QLabel("Labels",this,"label-labels");
  label->setGeometry(10,y,100,25);
  labels = new XYPlotAxisLabelWidget(this,"widget-labels");
  labels->move(70,y);
  y += 10 + labels->height();

  zero = new QCheckBox("Show zerolines",this,"check-zero");
  zero->setGeometry(10,y,150,25);
  y += 25;

  at_zero = new QCheckBox("Labels at zeroline",this,"check-at0");
  at_zero->setGeometry(10,y,150,25);
  y += 30;

  setFixedSize(300,y);
}

XYPlotLabelRangeWidget::~XYPlotLabelRangeWidget ()
{
  delete labels;
  labels = 0;
  delete range;
  range = 0;
  delete zero;
  zero = 0;
  delete at_zero;
  at_zero = 0;
}

void XYPlotLabelRangeWidget::setState (const XYPlotLabelRangeState& s)
{
  labels->setState(s.font,s.color,s.fmt);
  range->setState(s.mode,s.from,s.to);
  zero->setChecked(s.show_zero);
  at_zero->setChecked(s.label_at_zero);
}

void XYPlotLabelRangeWidget::state (XYPlotLabelRangeState& s)
{
  labels->state(s.font,s.color,s.fmt);
  range->state(s.mode,s.from,s.to);
  s.show_zero = zero->isChecked();
  s.label_at_zero = at_zero->isChecked();
}


/*
 * Implementation of XYPlot Axis Dialog
 *
 */

XYPlotAxisDialog::XYPlotAxisDialog (const char* title, XYAxisRecord* axis,
									int what,
									QWidget* parent, const char* name)
  : QTabDialog(parent,name,TRUE)
{
  the_axis = axis;
  the_what = what;

  range = new XYPlotLabelRangeWidget(this,"widget-range");
  if (what == 0)
	range->setState(the_axis->x_range);
  else
	range->setState(the_axis->y_range);
  addTab(range,"Range+Label");

  ticks = new XYPlotTickWidget(this,"widget-ticks");
  if (what == 0)
	ticks->setState(the_axis->x_ticks);
  else
	ticks->setState(the_axis->y_ticks);
  addTab(ticks,"Ticks");

  subticks = new XYPlotTickWidget(this,"widget-sub");
  if (what == 0)
	subticks->setState(the_axis->x_subticks);
  else
	subticks->setState(the_axis->y_subticks);
  addTab(subticks,"Subticks");

  setApplyButton();
  setCancelButton();
  setDefaultButton("Help");
  connect(this,SIGNAL(applyButtonPressed()),SLOT(apply()));
  connect(this,SIGNAL(defaultButtonPressed()),SLOT(clickHelp()));

  setCaption(title);
  setFixedSize(550,550);
}

XYPlotAxisDialog::~XYPlotAxisDialog ()
{
  delete range;
  range = 0;
  delete ticks;
  ticks = 0;
  delete subticks;
  subticks = 0;
}

void XYPlotAxisDialog::clickHelp ()
{
  kapp->invokeHTMLHelp("korigin/xyplot-axis.html","");
}

void XYPlotAxisDialog::apply ()
{
  if (the_what == 0) {
	range->state(the_axis->x_range);
	ticks->state(the_axis->x_ticks);
	subticks->state(the_axis->x_subticks);
  } else {
	range->state(the_axis->y_range);
	ticks->state(the_axis->y_ticks);
	subticks->state(the_axis->y_subticks);
  }
  emit settingsChanged ();
}
