c     -*- mode: FORTRAN -*-
c
c     This file is part of krot,
c     a program for the simulation, assignment and fit of HRLIF spectra.
c
c     Copyright (C) 1994-1998 Arnim Westphal
c     Copyright (C) 1997-1999 Jochen Kpper
c
c     If you use this program for your scientific work, please cite it according to
c     the file CITATION included with this package.
c
c     krot-arnirot
c     a program to calculate rotational resolved vibrational/vibronic bands


#include "arni.h"


c     setup krot-arnirot string variables
      subroutine setup ( npar,
     *                   cRotCg, cRotCe, cDRotC, cState, cEuler, no_yes, off_on,
     *                   frame, kind,
     *                   cBran, polax1,
     *                   symdes,
     *                   lngbar, lstars, lbars, ldash )

      implicit none

      integer        npar

      character*1    cBran(-1:1), polax1(3)
      character*2    symdes(0:1,0:1)
      character*3    no_yes(0:1), off_on(0:1)
      character*5    cRotCg(npar), cRotCe(npar), cEuler(3)
      character*7    cState(2)
      character*9    cDRotC(npar), kind(0:1)
      character*10   frame(0:1)
      character*81   lstars, lbars, ldash
      character*220  lngbar


      ARNIROT_LAUNCH ( "Launching setup." )

c     define labels for absolute and Delta rotational constants
      call lrotco( cRotCg, cRotCe, cDRotC, npar )
c     define labels for types of matrices and of frames
      call types( kind, frame )
c     define labels for binary switches
      call switch( no_yes, off_on )
c     define cartesian coordinate axes characters
      call polaxs( polax1 )
c     define the state character strings
      call states( cState )
c     define greek symbols for Euler angles
      call angles( cEuler )
c     define the branch characters
      call brans( cBran )
c     define labels for parity and symmetry species
      call symms( symdes )
c     define further commonly used parameters
      call mixed( lngbar, lstars, lbars, ldash )

      return
      end


c------------------------------------------------------------------------------
      subroutine lrotco( cRotCg, cRotCe, cDRotc, npar )
c     labels for rotational constants

      integer        npar
      character*5    cRotCg(npar), cRotCe(npar)
      character*9    cDRotC(npar)

      cRotCg(1)  = 'A'''''
      cRotCg(2)  = 'B'''''
      cRotCg(3)  = 'C'''''
      cRotCg(4)  = 'Dx'''''
      cRotCg(5)  = 'Dy'''''
      cRotCg(6)  = 'Dz'''''
      cRotCg(7)  = 'DJ'''''
      cRotCg(8)  = 'DJK'''''
      cRotCg(9)  = 'DK'''''
      cRotCg(10) = 'dJ'''''
      cRotCg(11) = 'dK'''''

      cRotCe(1)  = 'A'''
      cRotCe(2)  = 'B'''
      cRotCe(3)  = 'C'''
      cRotCe(4)  = 'Dx'''
      cRotCe(5)  = 'Dy'''
      cRotCe(6)  = 'Dz'''
      cRotCe(7)  = 'DJ'''
      cRotCe(8)  = 'DJK'''
      cRotCe(9)  = 'DK'''
      cRotCe(10) = 'dJ'''
      cRotCe(11) = 'dK'''

      cDRotC(1)  = 'Delta A'
      cDRotC(2)  = 'Delta B'
      cDRotC(3)  = 'Delta C'
      cDRotC(4)  = 'Delta Dx'
      cDRotC(5)  = 'Delta Dy'
      cDRotC(6)  = 'Delta Dz'
      cDRotC(7)  = 'Delta DJ'
      cDRotC(8)  = 'Delta DJK'
      cDRotC(9)  = 'Delta DK'
      cDRotC(10) = 'Delta dJ'
      cDRotC(11) = 'Delta dK'

      return
      end


c------------------------------------------------------------------------------
      subroutine types( kind, frame )
c     labels for types of matrices and frames

      character*9    kind(0:1)
      character*10   frame(0:1)

      kind(0)  = 'real'
      kind(1)  = 'imaginary'
      frame(0) = 'unswitched'
      frame(1) = 'switched'

      return
      end


c------------------------------------------------------------------------------
      subroutine switch( no_yes, off_on )
c     labels for binary switches

      character*3    no_yes(0:1), off_on(0:1)

      no_yes(0) = ' NO'
      no_yes(1) = 'YES'
      off_on(0) = 'OFF'
      off_on(1) = 'ON'

      return
      end


c------------------------------------------------------------------------------
      subroutine polaxs( polax1 )
c     cartesian coordinate axes characters

      character*1    polax1(3)

      polax1(1) = 'x'
      polax1(2) = 'y'
      polax1(3) = 'z'

      return
      end


c------------------------------------------------------------------------------
      subroutine states( cState )
c     strings defining state

      character*7    cState(2)

      cState(1) = 'ground'
      cState(2) = 'excited'

      return
      end


c------------------------------------------------------------------------------
      subroutine angles( cEuler )
c     names of switching (Euler) angles

      character*5    cEuler(3)

      cEuler(1) = 'theta'
      cEuler(2) = 'phi'
      cEuler(3) = 'chi'

      return
      end


c------------------------------------------------------------------------------
      subroutine brans( cBran )
c     branch characters

      character*1    cBran(-1:1)

      cBran(-1) = 'P'
      cBran( 0) = 'Q'
      cBran( 1) = 'R'

      return
      end


c------------------------------------------------------------------------------
      subroutine symms( symdes )
c     labels for parity and symmetry species

      character*2    symdes(0:1,0:1)

      symdes(0,0) = 'A '
      symdes(0,1) = 'Ba'
      symdes(1,0) = 'Bb'
      symdes(1,1) = 'Bc'

      return
      end


c------------------------------------------------------------------------------
      subroutine mixed( lngbar, lstars, lbars, ldash )
c     further commonly used string variables

      integer        i
      character*81   lstars, lbars, ldash
      character*220  lngbar

      do i = 1, 220, 1
         lngbar(i:i) = '_'
      end do
      lstars = '\n*******************************************************************************\n'
      lbars  =   '_______________________________________________________________________________\n'
      ldash  = '\n- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -'

      return
      end
