// -*- mode: C++; c-file-style: "Stroustrup" -*-
//
// This file is part of krot,
// a program for the simulation, assignment and fit of HRLIF spectra.
//
// Copyright (C) 1998,1999 Jochen Kpper
//
// This program is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free Software
// Foundation; either version 2 of the License, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
// more details.
//
// You should have received a copy of the GNU General Public License along with
// this program; see the file License. if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
//
// If you use this program for your scientific work, please cite it according to
// the file CITATION included with this package.



#ifndef KROT_RAWDATA_INLINE_H
#define KROT_RAWDATA_INLINE_H



inline RawDataPoint::RawDataPoint()
{
    return;
}



inline RawDataPoint::RawDataPoint( int val )
{
    signal = etalon = iodine = power = val;
    return;
}



inline const set< int >& RawData::marker() const
{
    return mks;
}



inline const RawDataPoint& RawData::operator[]( const int index )
{
    if( index > 0 && index < static_cast<int>( data.size()  )) {
	unsigned int interval = ( avg - 1 ) / 2;
	if( ( interval > 0 ) && ( 0 < index - interval ) && ( data.size() > index + interval ) ) {
	    avgData = data[ index ];
	    double val = 0;
	    for( unsigned int i = index - interval; i <= index + interval; i++ )
		val += data[ i ].signal;
	    avgData.signal = val / avg;
	    return avgData;
	} else
	    return data[ index ];
    } else
	return dataZero;
}



inline void RawData::setAveraging( unsigned int val )
{
    avg = val;
    return;
}



inline void RawData::toggleMarker( const int pos )
{
    set< int >::iterator high = mks.upper_bound( 2.1 + pos );
    if( *high - pos <= 2.1 ) {
	mks.erase( high );
    } else if( pos - *(--high) <= 2.1 ) {
	mks.erase( high );
    } else
	mks.insert( pos );
    return;
}



inline const RawDataPoint& RawData::max() const
{
    return mx;
}



inline const RawDataPoint& RawData::min() const
{
    return mn;
}



inline const unsigned int RawData::numMarker() const
{
    return mks.size();
}



inline const QString& RawData::name() const
{
    return filename;
}



inline const int RawData::size() const
{
    return data.size();
}




#endif
