#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/mman.h>
#include <fcntl.h>
#include <ctype.h>
#include <pwd.h>

#include <qapp.h>
#ifndef NOKDE
#include <kapp.h>
#endif

#include "gui.hpp"
#include "splash.hpp"

#define cp(a) printf("cp%d\n", a);

#ifndef VERSION
#define VERSION "0.1"
#endif

int main(int argc, char **argv)
{
#ifndef NOKDE
	KApplication a(argc, argv, "kturtle");
	QString s = a.kdedir() + "/lib/pics/kturtle.bmp";
	KSplash *w = new KSplash(0, s, VERSION);
	a.setMainWidget(w);
	w->show();
	a.processEvents();
	w->repaint();
	sleep(3);
	w->hide();
#else
	extern unsigned char kturtle[];
	QApplication a(argc, argv);
	KSplash *w = new KSplash(0, kturtle, 77878, VERSION);
	a.setMainWidget(w);
	w->show();
	a.processEvents();
	w->repaint();
	sleep(3);
	w->hide();
#endif


	KTurtleGUI t(0);
	a.setMainWidget(&t);
	t.show();

	w->close();
	delete w;

	a.exec();
}
