#include <stdio.h>
#include <qapp.h>
#include "splash.hpp"

KSplash::KSplash
(
	QWidget *p,
	QString &file,
	char *ver
)
: QWidget(p, "splash", WStyle_Customize|WStyle_NoBorder)
{
	pm = new QPixmap;
	pm->load(file, "BMP");
	setGeometry(QApplication::desktop()->width()/2-pm->width()/2,
		QApplication::desktop()->height()/2-pm->height()/2,
		pm->width(), pm->height());
	strncpy(version, ver, sizeof(version));
	version[sizeof(version)-1] = 0;
}

KSplash::KSplash
(
	QWidget *p,
	unsigned char *dat,
	int len,
	char *ver
)
: QWidget(p, "splash", WStyle_Customize|WStyle_NoBorder)
{
	pm = new QPixmap;
	pm->loadFromData(dat, len, "BMP");
	setGeometry(QApplication::desktop()->width()/2-pm->width()/2,
		QApplication::desktop()->height()/2-pm->height()/2,
		pm->width(), pm->height());
	strncpy(version, ver, sizeof(version));
	version[sizeof(version)-1] = 0;
}

KSplash::~KSplash()
{
	delete pm;
}

void KSplash::paintEvent
(
	QPaintEvent *
)
{
	QPainter p;
	char str[64];

	p.begin(this);
	p.drawPixmap(0, 0, *pm);
	sprintf(str, "version %s", version);
	p.drawText(0, 0, width(), 20, AlignRight|AlignTop, str);
	p.end();
}
