/*****************************************************************************
 * This software is distributed under the terms of the General Public License.
 *
 * Program :   kastrolog 5.4 beta 3
 * Authors : see the AUTHORS file
 * E-Mail  : Llyra@altavista.com
*****************************************************************************/ 


#include "AstroWidget.h"
#include "AstroMenu.h"
#include "SetAstroColor.h"
#include <qkeycode.h>
#include <kiconloader.h>

extern "C"
{
#include <ctype.h>
}

#define NewMenu(popup, text, accel) popup->insertItem(text, accel); \
popup->setAccel(accel, accel);
#define iftog(flag, key)  if(flag) Toggle(key)
#define action gi.fiskde = fFalse; Action(); gi.fiskde = fTrue
#define SwitchAction(flag) Toggle(i); not(flag); central->setPaint();
#define pop(var) *var = new QPopupMenu
#define seths(key, no) case CTRL + SHIFT + key : us.nHouseSystem = no; ToggleHousSys(); central->setPaint(); break;
#define chtype(i, f, c) ToggleType(i); central->ChartType(&us.f, c); break;
#define MenuMac if(szMacroName[i-1]) strcpy(buf, szMacroName[i-1]); else \
sprintf(buf, tr("Macro %d"), i);

extern AstroWidget *central;
extern KStatusBar  *Ksb;
extern KToolBar    *Ktb;
extern KIconLoader *Kil;
extern icons icons[];

char *ChartTitle[Progress+1], *TypeTitle[Progressed_Natal+1];

static const int TypeKeys[] = { Key_C, ALT+Key_Y, ALT+SHIFT+Key_Y, \
  ALT+SHIFT+Key_M, ALT+Key_D, Key_Y, ALT+Key_N, ALT+SHIFT+Key_N },

  HousSysKeys[] = { Key_P, Key_K, Key_E, Key_C, Key_M, Key_R, Key_Y, Key_U, \
  Key_T, Key_A, Key_Q, Key_O, Key_W, Key_V, Key_N },

  ChartTypeKeys[] = { SHIFT+Key_V, ALT+SHIFT+Key_V, SHIFT+Key_A, ALT+Key_L, ALT+Key_M, SHIFT+Key_Z, SHIFT+Key_S, SHIFT+Key_M, SHIFT+Key_K, SHIFT+Key_I, \
  SHIFT+Key_L, SHIFT+Key_E, ALT+Key_P, ALT+SHIFT+Key_L, ALT+SHIFT+Key_T, \
  ALT+SHIFT+Key_P },

  GraphKeys[] = { SHIFT+Key_W, SHIFT+Key_G, SHIFT+Key_P },
  nScaleType[] = { CTRL+Key_1, CTRL+Key_2, CTRL+Key_3, CTRL+Key_4 },
  JRateKeys[] = { Key_Exclam, Key_At, Key_NumberSign, Key_Dollar, Key_Percent,\
  Key_AsciiCircum, Key_Ampersand, Key_Apostrophe,Key_ParenLeft },
  JFactKeys[] = { Key_1, Key_2, Key_3, Key_4, Key_5, Key_6, Key_7, Key_8, Key_9 }; 

bool KMenuBar::isItemChecked(int id)
{
  return menu->isItemChecked(id);
}

void AstroMenu::ToggleChart(ChartMode cm)
{
  int c;
  if(!us.fWheel)
  {
    ToggleType(Wheel);
    central->ChartType(&us.fWheel, 'V');
  }
  if(cm == Comparison)
  {
    Toggle(Key_C);
    for(c = Synastry; c <= Progressed_Natal; c++)
      setItemChecked(TypeKeys[c], FALSE);
  }
  else
  {
    for(c = Comparison; c <= Progressed_Natal; c++)
      setItemChecked(TypeKeys[c], c == cm ? TRUE : FALSE);
  }
  for(c = List; c <= Progress; c++)
  {
    if(isItemChecked(ChartTypeKeys[c]))
      setItemChecked(ChartTypeKeys[c], FALSE);
  }
  for(c = Map; c <= Polar; c++)
  {
    if(isItemChecked(GraphKeys[c]))
      setItemChecked(GraphKeys[c], FALSE);
  }
  setItemChecked(ChartTypeKeys[Wheel], TRUE);
  Ksb->changeItem(TypeTitle[cm], 1);
}

void AstroMenu::ToggleType(ChartType ct)
{
  int c;
  for(c = List; c <= Progress; c++)
      setItemChecked(ChartTypeKeys[c], c == ct ? TRUE : FALSE);
  for(c = Map; c <= Polar; c++)
    if(isItemChecked(GraphKeys[c]))
      setItemChecked(GraphKeys[c], FALSE);
  for(c = Comparison; c <= Progressed_Natal; c++)
  {
    if(isItemChecked(TypeKeys[c]))
      setItemChecked(TypeKeys[c], FALSE);
  }
  Ksb->changeItem(ChartTitle[ct], 0);
}

void AstroMenu::ToggleGraph(GraphType ct)
{
  int c;
  for(c = Map; c <= Polar; c++)
      setItemChecked(GraphKeys[c], c == ct ? TRUE : FALSE);
  for(c = List; c <= Progress; c++)
    if(isItemChecked(ChartTypeKeys[c]))
      setItemChecked(ChartTypeKeys[c], FALSE);
  for(c = Comparison; c <= Progressed_Natal; c++)
    if(isItemChecked(TypeKeys[c]))
      setItemChecked(TypeKeys[c], FALSE);
}

void AstroMenu::TogglenScale(int i)
{
  int j;
  gs.nScale = i;
  for(j = Small; j <= Huge; j++)
    setItemChecked(nScaleType[j], FALSE);
  switch(i)
  {
    case 100 : setItemChecked(nScaleType[Small], TRUE); break;
    case 200 : setItemChecked(nScaleType[Medium], TRUE); break;
    case 300 : setItemChecked(nScaleType[Large], TRUE); break;
    case 400 : setItemChecked(nScaleType[Huge], TRUE); break;
  }
  central->setPaint(' ');
}

void AstroMenu::ToggleJRate(JRateType jr)
{
 int c;
 for(c = Seconds; c <= Millenia; c++)
      setItemChecked(JRateKeys[c], c == jr ? TRUE : FALSE);
}

void AstroMenu::ToggleJFact(JFact jf, int i)
{
  int c;
  central->SetDir(i);
  for(c = Unit_1; c <= Unit_9; c++)
      setItemChecked(JFactKeys[c], c == jf ? TRUE : FALSE);
}

AstroMenu::AstroMenu(QWidget* parent) : KMenuBar(parent, NULL)
{
  int i = 1, j;
  char buf[20], uni[2] = " ";
  minors = FALSE;
  QPopupMenu pop(fi), pop(ed), pop(m1), pop(m2), pop(m3), pop(m4), pop(view), \
    pop(ws), pop(info), pop(ch3), pop(ch4), pop(sett), pop(house), pop(hset),\
    pop(cha), pop(gra), pop(chsc), pop(glo), pop(anim), pop(jrate), \
    pop(jfact), pop(hlp), pop(doc), pop(nbjmp), pop(unijmp);
  Ksb->setInsertOrder(KStatusBar::RightToLeft);
  Ksb->insertItem("                                     ", 0);
  Ksb->insertItem("                             ", 1);
  for(j = 0; j <= LASTICON; j++)
	Ktb->insertButton(Kil->loadIcon(icons[j].s), icons[j].id, TRUE, icons[j].tip);
  for(j =1; j <= 9; j++)
  {
    uni[0] = j + '0';
    nbjmp->insertItem(uni);
  }
  Ktb->insertButton(Kil->loadIcon("anim2.xpm"), 10, nbjmp, TRUE, tr("Jump factor"));
  connect(nbjmp, SIGNAL(activated(int)), this, SLOT(nbsslot(int)));
  unijmp->insertItem(tr("Seconds"));
  unijmp->insertItem(tr("Minutes"));
  unijmp->insertItem(tr("Hours"));
  unijmp->insertItem(tr("Days"));
  unijmp->insertItem(tr("Months"));
  unijmp->insertItem(tr("Years"));
  unijmp->insertItem(tr("Decades"));
  unijmp->insertItem(tr("Centuries"));
  unijmp->insertItem(tr("Millenia"));
  Ktb->insertButton(Kil->loadIcon("anim2.xpm"), 11, unijmp, TRUE, tr("Jump Rate"));
  connect(unijmp, SIGNAL(activated(int)), this, SLOT(unitsslot(int)));
  connect(Ktb, SIGNAL(clicked(int)), SLOT(iconsslot(int)));
  NewMenu(fi, tr("Open Chart..."), ALT + Key_O);
  NewMenu(fi, tr("Open Chart #2..."), ALT + SHIFT + Key_O);
  fi->insertSeparator();
  NewMenu(fi, tr("Save Chart Info..."), ALT + Key_W);
  NewMenu(fi, tr("Save Chart Positions..."), ALT + SHIFT + Key_W);
  NewMenu(fi, tr("Save Chart Text Output..."), CTRL + Key_5);
  NewMenu(fi, tr("Save Chart Bitmap..."), CTRL + Key_6);
  NewMenu(fi, tr("Save Chart Picture..."), CTRL + Key_7);
  NewMenu(fi, tr("Save Chart Postscript..."), CTRL + Key_8);
  fi->insertSeparator();
  NewMenu(fi, tr("Save Settings..."), CTRL + Key_9);
  fi->insertSeparator();
  NewMenu(fi, tr("Print..."), CTRL + Key_P);
  NewMenu(fi, tr("Print Setup..."), CTRL + Key_Q);
  NewMenu(fi, tr("Quit..."), 'q');
  insertItem(tr("File"), fi);
  NewMenu(ed, tr("Command Line..."), Key_Return);
  ed->insertSeparator();
  while(i <= 12)
    {
      MenuMac;
      NewMenu(m1, buf, Key_F1 + i - 1);
      i++;
    }
  ed->insertItem(tr("Run Macros (Normal Set)"), m1);
  while(i <= 24)
    {
      MenuMac;
      NewMenu(m2, buf, SHIFT + Key_F1 + i - 13);
      i++;
    }
  ed->insertItem(tr("Run Macros (Shift Set)"), m2);
  while(i <= 36)
    {
      MenuMac;
      NewMenu(m3, buf, CTRL + Key_F1 + i - 25);
      i++;
    }
  ed->insertItem(tr("Run Macros (Control Set)"), m3);
  while(i <= 48)
    {
      MenuMac;
      NewMenu(m4, buf, ALT + Key_F1 + i - 37);
      i++;
    }
  ed->insertItem(tr("Run Macros (Alt Set)"), m4);
  //ed->insertSeparator();
  insertItem(tr("Edit"), ed);
  NewMenu(view, tr("Show Graphic..."), Key_V);
  view->insertItem(tr("Window Settings"), ws);
  NewMenu(ws, tr("Buffer Redraws"), Key_Tab);
  NewMenu(ws, tr("Redraw Screen"), Key_Space);
  NewMenu(ws, tr("Clear Screen"), Key_Delete);
  ws->insertSeparator();
  NewMenu(ws, tr("Window Resizes Chart"), ALT + Key_Q);
  NewMenu(ws, tr("Page Up"), Key_PageUp);
  NewMenu(ws, tr("Page Down"), Key_PageDown);
  NewMenu(ws, tr("Home"), Key_Home);
  NewMenu(ws, tr("End"), Key_End);
  NewMenu(view, tr("Colored Text"), ALT + Key_K);
  NewMenu(view, tr("Set Palette..."), ALT +SHIFT + Key_K);
  NewMenu(view, tr("Set Colors..."), ALT + SHIFT + Key_Percent);
  NewMenu(view, tr("Show Interpretation"), ALT + SHIFT + Key_I);
  NewMenu(view, tr("Print Nearest second"), ALT + Key_B);
  NewMenu(view, tr("Applying Aspects"), ALT + Key_X);
  NewMenu(view, tr("Parallel Aspects"), ALT + SHIFT + Key_X);
  insertItem(tr("View"), view);
  NewMenu(info, tr("Set Chart Info..."), ALT + Key_Percent);
  NewMenu(info, tr("Chart For Now"), Key_N);
  NewMenu(info, tr("Default Chart Info..."), ALT +Key_D);
  info->insertSeparator();
  NewMenu(info, tr("Set Chart #2 Info..."), ALT + SHIFT +Key_Z);
  NewMenu(ch3, tr("Set Chart #3 Info..."), SHIFT +Key_3);
  NewMenu(ch3, tr("Open Chart #4 ..."), ALT + SHIFT + Key_3);
  info->insertItem(tr("Chart #3"), ch3);
  NewMenu(ch4, tr("Set Chart #4 Info..."), SHIFT + Key_4);
  NewMenu(ch4, tr("Open Chart #4 ..."), ALT + SHIFT + Key_4);
  info->insertItem(tr("Chart #4"), ch4);
  info->insertSeparator();
  NewMenu(info, TypeTitle[Comparison], Key_C);
  NewMenu(info, TypeTitle[Synastry], ALT + Key_Y);
  NewMenu(info, TypeTitle[Composite], ALT + SHIFT + Key_Y);
  NewMenu(info, TypeTitle[Time_Space], ALT + SHIFT +Key_M);
  info->insertSeparator();
  NewMenu(info, TypeTitle[Date_Diff], ALT + Key_D);
  NewMenu(info, TypeTitle[Biorhythm], SHIFT + Key_Y);
  NewMenu(info, TypeTitle[Transit_Natal], ALT + Key_N);
  NewMenu(info, TypeTitle[Progressed_Natal], ALT + SHIFT + Key_N);
  insertItem(tr("Info"), info);
  NewMenu(sett, tr("Sidereal Zodiac"), Key_S);
  NewMenu(sett, tr("Heliocentric"), Key_H);
  NewMenu(house, szSystem[0], CTRL+ SHIFT+ Key_P);
  NewMenu(house, szSystem[1], CTRL + SHIFT+ Key_K);
  NewMenu(house, szSystem[2], CTRL + SHIFT+ Key_E);
  NewMenu(house, szSystem[3], CTRL + SHIFT+ Key_C);
  NewMenu(house, szSystem[4], CTRL + SHIFT+ Key_M);
  NewMenu(house, szSystem[5], CTRL + SHIFT+ Key_R);
  NewMenu(house, szSystem[6], CTRL + SHIFT+ Key_Y);
  NewMenu(house, szSystem[7], CTRL + SHIFT+ Key_U);
  NewMenu(house, szSystem[8], CTRL + SHIFT+ Key_T);
  NewMenu(house, szSystem[9], CTRL + SHIFT+ Key_A);
  NewMenu(house, szSystem[10], CTRL + SHIFT+ Key_Q);
  NewMenu(house, szSystem[11], CTRL + SHIFT+ Key_O);
  NewMenu(house, szSystem[12], CTRL + SHIFT+ Key_W);
  NewMenu(house, szSystem[13], CTRL + SHIFT+ Key_V);
  NewMenu(house, szSystem[14], CTRL + SHIFT+ Key_N);
  sett->insertItem(tr("House System"), house);
  NewMenu(hset, tr("Solar Chart"), ALT + Key_1);
  NewMenu(hset, tr("Show Decan"), Key_G);
  NewMenu(hset, tr("Flip Signs & Houses"), Key_F);
  NewMenu(hset, tr("Geodetic Houses"), ALT + SHIFT + Key_H);
  hset->insertSeparator();
  NewMenu(hset, tr("Vedic Wheel Display"), Key_Z);
  NewMenu(hset, tr("Show Navamsas"), Key_Y);
  sett->insertItem(tr("House Settings"), hset);
  NewMenu(sett, tr("Aspects Settings..."), ALT + SHIFT + Key_A);
  NewMenu(sett, tr("Objects Settings..."), ALT + Key_J);
  NewMenu(sett, tr("More Objects Settings..."), ALT + SHIFT + Key_J);
  sett->insertSeparator();
  NewMenu(sett, tr("Restrictions..."), ALT + Key_R);
  NewMenu(sett, tr("Include Minors"), SHIFT + Key_R);
  NewMenu(sett, tr("Include Cusps"), SHIFT + Key_C);
  NewMenu(sett, tr("Include Uranians"), Key_U);
  NewMenu(sett, tr("Include Fixed Stars"), SHIFT + Key_U);
  NewMenu(sett, tr("Star Restrictions..."), ALT + SHIFT + Key_R);
  NewMenu(sett, tr("Transit Restrictions..."), ALT + SHIFT + Key_F);
  sett->insertSeparator();
  NewMenu(sett, tr("Calculation Settings..."), ALT + SHIFT + Key_S);
  NewMenu(sett, tr("Obscure Settings..."), ALT + SHIFT + Key_B);
  insertItem(tr("Settings"), sett);
  NewMenu(cha, ChartTitle[List], ChartTypeKeys[List]);
  NewMenu(cha, ChartTitle[Wheel], ChartTypeKeys[Wheel]);
  NewMenu(cha, ChartTitle[Grid], ChartTypeKeys[Grid]);
  NewMenu(cha, ChartTitle[Aspect], ChartTypeKeys[Aspect]);
  NewMenu(cha, ChartTitle[MidPoint], ChartTypeKeys[MidPoint]);
  NewMenu(cha, ChartTitle[Horizon], ChartTypeKeys[Horizon]);
  NewMenu(cha, ChartTitle[Orbit], ChartTypeKeys[Orbit]);
  NewMenu(cha, ChartTitle[Sector], ChartTypeKeys[Sector]);
  NewMenu(cha, ChartTitle[Calendar], ChartTypeKeys[Calendar]);
  NewMenu(cha, ChartTitle[Influence], ChartTypeKeys[Influence]);
  NewMenu(cha, ChartTitle[AstroGraph], ChartTypeKeys[AstroGraph]);
  NewMenu(cha, ChartTitle[Ephemeris], ChartTypeKeys[Ephemeris]);
  NewMenu(cha, ChartTitle[Arabic], ChartTypeKeys[Arabic]);
  NewMenu(cha, ChartTitle[Rising], ChartTypeKeys[Rising]);
  cha->insertSeparator();
  NewMenu(cha, ChartTitle[Transit], ChartTypeKeys[Transit]);
  NewMenu(cha, ChartTitle[Progress], ChartTypeKeys[Progress]);
  cha->insertSeparator();
  NewMenu(cha, tr("Chart Settings..."), ALT + SHIFT + Key_C);
  insertItem(tr("Chart"), cha);
  NewMenu(gra, tr("Show World Map"), GraphKeys[Map]);
  NewMenu(gra, tr("Show Globe"), GraphKeys[Globe]);
  NewMenu(gra, tr("Show Polar Globe"), GraphKeys[Polar]);
  NewMenu(gra, tr("Show Constellations"), SHIFT + Key_F);
  gra->insertSeparator();
  NewMenu(gra, tr("Reverse Background"), Key_X);
  NewMenu(gra, tr("Monochrome"), Key_M);
  NewMenu(gra, tr("Show Border"), Key_B);
  NewMenu(gra, tr("Show Chart Info"), Key_T);
  NewMenu(gra, tr("Show Info SideBar"), ALT + Key_T);
  NewMenu(gra, tr("Show Glyph Labels"), Key_L);
  NewMenu(gra, tr("Square Screen"), CTRL + ALT + Key_Q);
  NewMenu(chsc, tr("Small"), nScaleType[Small]);
  NewMenu(chsc, tr("Medium"), nScaleType[Medium]);
  NewMenu(chsc, tr("Large"), nScaleType[Large]);
  NewMenu(chsc, tr("Huge"), nScaleType[Huge]);
  chsc->insertSeparator();
  NewMenu(chsc, tr("Decrease"), Key_Less);
  NewMenu(chsc, tr("Increase"), Key_Greater);
  gra->insertItem(tr("Character Scale"), chsc);
  NewMenu(glo, tr("Set to Zero"), ALT + SHIFT + Key_E);
  glo->insertSeparator();
  NewMenu(glo, tr("Decrease"), Key_BracketLeft);
  NewMenu(glo, tr("Increase"), Key_BracketRight);
  gra->insertItem(tr("Globe Tilt"), glo);
  gra->insertSeparator();
  NewMenu(gra, tr("Modify Display"), Key_I);
  NewMenu(gra, tr("Modify Chart"), SHIFT + Key_O);
  //NewMenu(gra, tr("Scribble Color"), CTRL + Key_Z); This function is not clear for the moment
  NewMenu(gra, tr("Graphic Settings..."), ALT + SHIFT + Key_G);
  insertItem(tr("Graphics"), gra);
  NewMenu(anim, tr("Stop Animation"), SHIFT + Key_N);
  NewMenu(jrate, tr("Update to Now"), CTRL + ALT + Key_N);
  jrate->insertSeparator();
  NewMenu(jrate, tr("Seconds"), JRateKeys[Seconds]);
  NewMenu(jrate, tr("Minutes"), JRateKeys[Minutes]);
  NewMenu(jrate, tr("Hours"), JRateKeys[Hours]);
  NewMenu(jrate, tr("Days"), JRateKeys[Days]);
  NewMenu(jrate, tr("Months"), JRateKeys[Months]);
  NewMenu(jrate, tr("Years"), JRateKeys[Years]);
  NewMenu(jrate, tr("Decades"), JRateKeys[Decades]);
  NewMenu(jrate, tr("Centuries"), JRateKeys[Centuries]);
  NewMenu(jrate, tr("Millenia"), JRateKeys[Millenia]);
  anim->insertItem(tr("Jump Rate"), jrate);
  NewMenu(jfact, tr("1 Unit"), JFactKeys[Unit_1]);
  NewMenu(jfact, tr("2 Units"), JFactKeys[Unit_2]);
  NewMenu(jfact, tr("3 Units"), JFactKeys[Unit_3]);
  NewMenu(jfact, tr("4 Units"), JFactKeys[Unit_4]);
  NewMenu(jfact, tr("5 Units"), JFactKeys[Unit_5]);
  NewMenu(jfact, tr("6 Units"), JFactKeys[Unit_6]);
  NewMenu(jfact, tr("7 Units"), JFactKeys[Unit_7]);
  NewMenu(jfact, tr("8 Units"), JFactKeys[Unit_8]);
  NewMenu(jfact, tr("9 Units"), JFactKeys[Unit_9]);
  anim->insertItem(tr("Jump Factor"), jfact);
  NewMenu(anim, tr("Reverse Direction"), Key_R);
  NewMenu(anim, tr("Pause Animation"), Key_P);
  NewMenu(anim, tr("Timed Exposure"), Key_J);
  anim->insertSeparator();
  NewMenu(anim, tr("Step Forward"), Key_Plus);
  NewMenu(anim, tr("Step Backward"), Key_Minus);
  NewMenu(anim, tr("Store Chart Info"), Key_O);
  NewMenu(anim, tr("Recall Chart Info"), SHIFT + Key_O);
  insertItem(tr("Animation"), anim);
  NewMenu(doc, tr("Open Defaults"), CTRL + Key_ParenRight);
  NewMenu(doc, tr("Open Summary"), CTRL + Key_Exclam);
  NewMenu(doc, tr("Open Readme"), CTRL + Key_At);
  NewMenu(doc, tr("Open Update"), CTRL + Key_Percent);
  NewMenu(doc, tr("Helpfile"), CTRL + Key_Dollar);
  doc->insertSeparator();
  NewMenu(doc, tr("Open HomePage"), Key_ParenRight);
  hlp->insertItem(tr("Documentation"), doc);
  NewMenu(hlp, tr("List Signs"), ALT + Key_2);
  NewMenu(hlp, tr("List Objects"), ALT + Key_3);
  NewMenu(hlp, tr("List Aspects"), ALT + Key_4);
  NewMenu(hlp, tr("List Constellations"), ALT + Key_5);
  NewMenu(hlp, tr("List Planet Info"), ALT + Key_6);
  NewMenu(hlp, tr("List General Meanings"), ALT + Key_7);
  NewMenu(hlp, tr("List Switches"), ALT + Key_8);
  NewMenu(hlp, tr("List Obscure Switches"), ALT + Key_9);
  NewMenu(hlp, tr("List KeyStrokes"), Key_Question);
  NewMenu(hlp, tr("List Credits"), ALT + Key_O);
  hlp->insertSeparator();
  NewMenu(hlp, tr("About KAstrolog..."), CTRL + Key_O);
  insertItem(tr("help"), hlp);
  connect(this, SIGNAL(activated(int)), this, SLOT(menuslot(int)));
  iftog(us.fGraphics, Key_V);
  iftog(us.fAnsiColor, ALT + Key_K);
  iftog(us.fInterpret, ALT + SHIFT + Key_I);
  iftog(us.fSeconds, ALT + Key_B);
  iftog(us.fAppSep, ALT + Key_X);
  iftog(us.fParallel, ALT + SHIFT + Key_X);
  iftog(us.fSidereal, Key_S);
  iftog(us.objCenter == oSun, Key_H); 
  iftog(us.fSolarArc, ALT +Key_1);
  iftog(us.fDecan, Key_G);
  iftog(us.fFlip, Key_F);
  iftog(us.fGeodetic, ALT + SHIFT + Key_H);
  iftog(us.fVedic, Key_Z);
  iftog(us.fNavamsa, Key_Y);
  iftog(minors, Key_R);
  iftog(us.fCusp, SHIFT + Key_C);
  iftog(us.fUranian, Key_U);
  iftog(us.nStar, SHIFT + Key_U);
  
  if(us.fListing) ToggleType(List);
  else if(us.fWheel) ToggleType(Wheel);
  else if(us.fGrid) ToggleType(Grid);
  else if(us.fAspList) ToggleType(Aspect);
  else if(us.fMidpoint) ToggleType(MidPoint);
  else if(us.fHorizon && !us.fHorizonSearch) ToggleType(Horizon);
  else if(us.fOrbit) ToggleType(Orbit);
  else if(us.fSector) ToggleType(Sector);
  else if(us.fCalendar) ToggleType(Calendar);
  else if(us.fInfluence) ToggleType(Influence);
  else if(us.fAstroGraph) ToggleType(AstroGraph);
  else if(us.fEphemeris) ToggleType(Ephemeris);
  else if(us.nArabic) ToggleType(Arabic);
  else if(us.fHorizon && us.fHorizonSearch) ToggleType(Rising);
  else if(us.fTransit) ToggleType(Transit);
  else
  {
    us.fWheel = fTrue; ToggleType(Wheel);
  }

  switch(us.nRel)
  {
    //case 0           : ToggleChart(Comparison); break;
    case '1'          : ToggleChart(Comparison); break;
    case rcSynastry   : ToggleChart(Synastry); break;
    case rcComposite  : ToggleChart(Composite); break;
    case rcMidpoint   : ToggleChart(Time_Space); break;
    case rcDifference : ToggleChart(Date_Diff); break;
    case rcBiorhythm  : ToggleChart(Biorhythm); break;
    case rcTransit    : ToggleChart(Transit_Natal); break;
    case rcProgress   : ToggleChart(Progressed_Natal); break;
    default           : ;
  }
  ToggleHousSys();
  iftog(gi.nMode == gWorldMap, SHIFT + Key_W);
  iftog(gi.nMode == gGlobe, SHIFT + Key_G);
  iftog(gi.nMode == gPolar, SHIFT + Key_P);
  iftog(gs.fConstel, SHIFT + Key_F);
  iftog(gs.fInverse, Key_X);
  iftog(!gs.fColor, Key_M);
  iftog(fDrawBorder, Key_B);
  iftog(!fDrawText, Key_T);
  iftog(fSidebar, ALT + Key_T);
  iftog(gs.fLabel, Key_L);
  iftog(fSquare, SHIFT + Key_Q);
  iftog(gs.nScale == 100, nScaleType[Small]);
  iftog(gs.nScale == 200, nScaleType[Medium]);
  iftog(gs.nScale == 300, nScaleType[Large]);
  iftog(gs.nScale == 400, nScaleType[Huge]);
  Toggle(SHIFT + Key_N);
  Toggle(Key_At);
  Toggle(Key_1);
  Toggle(Key_J);
}

void AstroMenu::Toggle(int i)
{
    setItemChecked(i, (isItemChecked(i)) ? FALSE : TRUE);
}

void AstroMenu::ToggleHousSys()
{
  int i;
  for(i = 0; i < 15; i++)
    setItemChecked(CTRL + SHIFT + HousSysKeys[i], (i == us.nHouseSystem) ? TRUE : FALSE);
}

void AstroMenu::menuslot(int i)
{
  switch(i)
  {
    case ALT + Key_O         : central->Inputfile(ciMain); break; // Open Chart
    case ALT + SHIFT + Key_O : central->Inputfile(ciTwin); break; // Open Chart #2
    case ALT + Key_W         : central->OutputFile(); break; // Save Chart Info
    case ALT + SHIFT + Key_W : central->OutputFile(SaveOutput); break; // Save Output pos
    case CTRL + Key_5        : central->OutputFile(SaveText); break; // Save Text
    case CTRL + Key_6        : central->OutputFile(SaveBitmap); break; // Save Bitmap
    case CTRL + Key_7        : central->OutputFile(SavePicture); break; // Save WMF
    case CTRL + Key_8        : central->OutputFile(SavePostscript); break; // SAve PostScript
    case CTRL + Key_9        : central->OutputFile(SaveSettings); break; // Save settings
    case CTRL + Key_Q        : central->PrintDialog(); break; // Display a print dialog
    case CTRL + Key_P        : central->Print(); break; // Print current chart

    case Key_Return          : central->Command(); break; // Wait for a line of commands and execute it
      // !!! gcc feature only !!!
  case Key_F1 ... Key_F12  : central->RunMacro(i-Key_F1); break; // execute macros from F1 to F12

    case SHIFT + Key_F1 ... SHIFT + Key_F12 : central->RunMacro(i-(SHIFT+Key_F1)+12); break; //execute macros from Shift F1 to Shift F12
   case CTRL + Key_F1 ... CTRL + Key_F12 : central->RunMacro(i-(CTRL+Key_F1)+24); break; // Run macros from Ctrl F1 to Ctrl F12 
   
   case ALT + Key_F1 ... ALT + Key_F12 : central->RunMacro(i-(ALT+Key_F1)+36); break; // Run macros from Alt F1 to Alt F12 
   case Key_V                : Toggle(i); central->setPaint(tolower(i)); break;
   case ALT + Key_Q          : Toggle(i); central->ResizeChart(); break;
   case Key_PageUp           : central->Scroll(DirUp); break;
   case Key_PageDown         : central->Scroll(DirDown); break;
   case Key_Home             : central->Scroll(DirTop); break;
   case Key_End              : central->Scroll(DirBottom); break;
   case ALT + Key_K          : Toggle(i); central->ColoredText(); break;
   case ALT + SHIFT + Key_K  : central->SetPalette(); break;
   case ALT + SHIFT + Key_Percent : central->SetEAColors(); break;
   case ALT + SHIFT +Key_I   : Toggle(i); not(us.fInterpret);
     if(us.fInterpret)
       {
	 gi.fiskde = fFalse; ChartListing(); gi.fiskde = fTrue;
	 gi.nMode = gList;
       }
     else
       gi.nMode = gWheel;
     not(us.fGraphics);Toggle(Key_V); central->setPaint(' '); break;
   case ALT + Key_B         : Toggle(i); not(us.fSeconds); is.fSeconds = us.fSeconds; central->setPaint(); break;
   case ALT + Key_X         : Toggle(i); not(us.fAppSep); central->setPaint(); break;
   case ALT + Key_Percent   : central->SetChartInfo(ciMain); break;
   case ALT + SHIFT +Key_X  : SwitchAction(us.fParallel); break;
   case ALT +Key_D          : central->SetChartDefaultInfo(); break;
   case ALT + SHIFT + Key_Z : central->SetChartInfo(ciTwin); break;
   case SHIFT + Key_3       : central->SetChartInfo(ciThre); break;
   case ALT + SHIFT + Key_3 : central->Inputfile(ciThre); break;
   case SHIFT + Key_4       : central->SetChartInfo(ciFour); break;
   case ALT + SHIFT + Key_4 : central->Inputfile(ciFour); break;
   case Key_C               : ToggleChart(Comparison);  central->SetRelation(0); break; //setPaint('c'); break;
   case ALT + Key_Y         : ToggleChart(Synastry); central->SetRelation(rcSynastry); break;
   case ALT + SHIFT + Key_Y : ToggleChart(Composite); central->SetRelation(rcComposite); break;
   case ALT + SHIFT + Key_M : ToggleChart(Time_Space); central->SetRelation(rcMidpoint); break;
   case ALT + SHIFT + Key_D : ToggleChart(Date_Diff); central->SetRelation(rcDifference); break;
   case SHIFT + Key_Y       : ToggleChart(Biorhythm); central->SetRelation(rcBiorhythm); break;
   case ALT + Key_N         : ToggleChart(Transit_Natal); central->SetRelation(rcTransit); break;
   case ALT + SHIFT + Key_N : ToggleChart(Progressed_Natal); central->SetRelation(rcProgress); break;
   case Key_S               : Toggle(Key_S); central->setPaint(tolower(i)); break;
   case Key_H               : Toggle(Key_H); central->setPaint(tolower(i)); break;
   seths(Key_P, 0);
   seths(Key_K, 1);
   seths(Key_E, 2);
   seths(Key_C, 3);
   seths(Key_M, 4);
   seths(Key_R, 5);
   seths(Key_Y, 6);
   seths(Key_U, 7);
   seths(Key_T, 8);
   seths(Key_A, 9);
   seths(Key_Q, 10);
   seths(Key_O, 11);
   seths(Key_W, 12);
   seths(Key_V, 13);
   seths(Key_N, 14);
   case ALT + Key_1         : Toggle(i); central->setPaint(ALT + Key_1); break;
   case Key_G               : Toggle(i); central->setPaint(tolower(i)); break;
   case Key_F               : Toggle(i); central->setPaint(tolower(i)); break;
   case ALT + SHIFT + Key_H : Toggle(i); central->setPaint(ALT + SHIFT + Key_H); break;
   case Key_Z               : Toggle(i); central->setPaint(tolower(i)); break;
   case Key_Y               : Toggle(i); central->setPaint(tolower(i)); break;
   case ALT + SHIFT + Key_A : central->AspectSettings(); break;
   case ALT + Key_J         : central->ObjectSettings(tr("Object Settings..."),1, 0); break;
   case ALT + SHIFT + Key_J : central->ObjectSettings(tr("Cusp & Uranian Settings"), 21, 0); break;
   case ALT + Key_R         : central->Restrict(tr("Object Restrictions"), ignore, ignore2); break;
   case SHIFT + Key_R       : Toggle(i); not(minors); central->ToggleObj(oPlu, oEP, !minors); break;
   case SHIFT + Key_C       : Toggle(i); not(us.fCusp); central->ToggleObj(cuspLo-1, cuspHi, !us.fCusp); break;
   case Key_U               : Toggle(i); not(us.fUranian); central->ToggleObj(uranLo-1, uranHi, !us.fUranian); break;
   case SHIFT + Key_U       : Toggle(i); not(us.nStar); central->setPaint();  break;
   case ALT + SHIFT + Key_R : central->RestrictStar(); break;
   case ALT + SHIFT + Key_F : central->Restrict(tr("Transit Object Restrictions"), ignore2, ignore); break;
   case ALT + SHIFT + Key_S : central->CalculationSettings(); break;
   case ALT + SHIFT + Key_B : central->ObscureSetting(); break;
   case SHIFT + Key_V       : chtype(List, fListing, 'v');
   case ALT + SHIFT + Key_V : chtype(Wheel, fWheel, 'V');
   case SHIFT + Key_A       : chtype(Grid, fGrid, 'A');
   case ALT + Key_L         : chtype(Aspect, fAspList, ' ');
   case ALT + Key_M         : chtype(MidPoint, fMidpoint, ' ');
   case SHIFT + Key_Z       : chtype(Horizon, fHorizon, 'Z');
   case SHIFT + Key_S       : chtype(Orbit, fOrbit, 'S');
   case SHIFT + Key_M       : chtype(Sector, fSector, 'M');
   case SHIFT + Key_K       : chtype(Calendar, fCalendar, 'K');
   case SHIFT + Key_I       : chtype(Influence, fInfluence, 'J');
   case SHIFT + Key_L       : chtype(AstroGraph, fAstroGraph, 'L');
   case SHIFT + Key_E       : chtype(Ephemeris, fEphemeris, 'E');
   case ALT + Key_P         : chtype(Arabic, nArabic, ' ');
   case ALT + SHIFT + Key_L : chtype(Rising, fHorizon, ' ');
   case ALT + SHIFT + Key_T : if(central->Transits()) ToggleType(Transit); break;
   case ALT + SHIFT + Key_P : if(central->Progressions()) ToggleType(Progress); break;
   case ALT + SHIFT + Key_C : central->ChartSettings(); break;
   case SHIFT + Key_W       : ToggleGraph(Map); gi.nMode = gWorldMap; central->setPaint(); break;
   case SHIFT + Key_G       : ToggleGraph(Globe); gi.nMode = gGlobe; central->setPaint(); break;
   case SHIFT + Key_P       : ToggleGraph(Polar); gi.nMode = gPolar; central->setPaint(); break;
   case SHIFT + Key_F       : SwitchAction(gs.fConstel); break;
   case Key_X               : Toggle(i); central->setPaint(tolower(i)); break;
   case Key_M               : Toggle(i); central->setPaint(tolower(i)); break;
   case Key_B               : Toggle(i); central->setPaint(tolower(i)); break;
   case Key_T               : Toggle(i); central->setPaint(tolower(i)); break;
   case Key_L               : Toggle(i); central->setPaint(tolower(i)); break;
   case ALT + Key_T         : not(us.fVelocity); Toggle(i); central->setPaint('b'); break;
   case SHIFT + Key_Q       : Toggle(i); central->setPaint(tolower(i)); break;
   case CTRL + Key_1        : TogglenScale(100); break;
   case CTRL + Key_2        : TogglenScale(200); break;
   case CTRL + Key_3        : TogglenScale(300); break;
   case CTRL + Key_4        : TogglenScale(400); break;
   case Key_Less            : if(gs.nScale >= 200) { gs.nScale -= 100; TogglenScale(gs.nScale); } break;      
   case Key_Greater         : if(gs.nScale <= 300) { gs.nScale += 100; TogglenScale(gs.nScale); } break;
   case ALT + SHIFT + Key_E : if (gs.rTilt != 0.0) gs.rTilt = 0.0; central->setPaint(); break;
   case Key_BracketLeft     : if (gs.rTilt > -rDegQuad) gs.rTilt = gs.rTilt > -rDegQuad ? gs.rTilt-TILTSTEP : -rDegQuad; central->setPaint(' '); break;
   case Key_BracketRight    : if (gs.rTilt < rDegQuad) gs.rTilt = gs.rTilt < rDegQuad ? gs.rTilt+TILTSTEP : rDegQuad; central->setPaint(' '); break;
   case Key_I               : not(gs.fAlt); central->setPaint(' '); break;
   case CTRL + ALT + Key_O       :  not(us.fPrimeVert); not(us.fCalendarYear); not(us.nEphemYears); not(gs.fMollewide); gi.nMode = (gi.nMode == gWheel ? gHouse : (gi.nMode == gHouse ? gWheel : gi.nMode)); central->setPaint(' '); break;
   case ALT + SHIFT + Key_G : central->GraphicSettings(); break;
     //case CTRL + Key_Z        :
   case SHIFT + Key_N       : Toggle(SHIFT + Key_N); central->Anim(0); break;
   case CTRL + ALT + Key_N  : central->Anim(10); break;
   case Key_Exclam          : ToggleJRate(Seconds); central->Anim( -1); break;
   case Key_At              : ToggleJRate(Minutes); central->Anim(-2); break;
   case Key_NumberSign      : ToggleJRate(Hours); central->Anim(-3); break;
   case Key_Dollar          : ToggleJRate(Days); central->Anim(-4); break;
   case Key_Percent         : ToggleJRate(Months); central->Anim(-5); break;
   case Key_AsciiCircum     : ToggleJRate(Years); central->Anim(-6); break;
   case Key_Ampersand       : ToggleJRate(Decades); central->Anim(-7); break;
   case Key_Apostrophe      : ToggleJRate(Centuries); central->Anim(-8); break;
   case Key_ParenLeft       : ToggleJRate(Millenia); central->Anim(-9); break;
   case Key_1               : ToggleJFact(Unit_1, 1); break;
   case Key_2               : ToggleJFact(Unit_2, 2); break;
   case Key_3               : ToggleJFact(Unit_3, 3); break;
   case Key_4               : ToggleJFact(Unit_4, 4); break;
   case Key_5               : ToggleJFact(Unit_5, 5); break;
   case Key_6               : ToggleJFact(Unit_6, 6); break;
   case Key_7               : ToggleJFact(Unit_7, 7); break;
   case Key_8               : ToggleJFact(Unit_8, 8); break;
   case Key_9               : ToggleJFact(Unit_9, 9); break;
   case Key_R               : Toggle(i); central->SetDir(-1); break;
   case Key_P               : Toggle(i); central->SetPause(); break;
   case Key_J               : Toggle(i); central->TimedExpos(); break;
   case SHIFT + Key_O       : central->setPaint(i); break;
   case CTRL + Key_ParenRight : central->ListFile("astrolog.dat"); break;
   case CTRL + Key_Exclam   : central->ListFile("file_id.diz"); break;
   case CTRL + Key_At       : central->ListFile("readme.540"); break;
   case CTRL + Key_Percent  : central->ListFile("update.540"); break;
   case CTRL + Key_Dollar   : central->ListFile("helpfile.540"); break;
   case ALT  + Key_2        : central->ChartType(&us.fSign, ' '); break;
   case ALT  + Key_3        : central->ChartType(&us.fObject, ' '); break;
   case ALT  + Key_4        : central->ChartType(&us.fAspect, ' '); break;
   case ALT  + Key_5        : central->ChartType(&us.fConstel, ' '); break;
   case ALT  + Key_6        : central->ChartType(&us.fOrbitData, ' '); break;
   case ALT  + Key_7        : central->ChartType(&us.fMeaning, ' '); break;
   case ALT  + Key_8        : central->ChartType(&us.fKeyGraph, ' '); break;
   case CTRL + Key_O        : central->About(); break;
   default                  : central->setPaint(tolower(i));
    }
}

void AstroMenu::iconsslot(int i)
{
  switch(i)
  {
     case 0 :  central->Inputfile(ciMain); break;
     case 1 :  central->SetChartInfo(ciMain); break;
     case 2 :  central->setPaint('n'); break;
     case 3 :  Toggle(Key_X); central->setPaint('x'); break;
     case 4 :  Toggle(Key_M); central->setPaint('m'); break;
     case 5 :  ToggleChart(Comparison); central->SetRelation(0); break;
     case 6 :  Toggle(SHIFT + Key_N); central->Anim(0); break;
     case 7 :  Toggle(i); central->SetDir(-1); break;
     default:;
  }
}

void AstroMenu::nbsslot(int i)
{
  switch(i)
  {
     case 0: ToggleJFact(Unit_1, 1); break;
     case 1: ToggleJFact(Unit_2, 2); break;
     case 2: ToggleJFact(Unit_3, 3); break;
     case 3: ToggleJFact(Unit_4, 4); break;
     case 4: ToggleJFact(Unit_5, 5); break;
     case 5: ToggleJFact(Unit_6, 6); break;
     case 6: ToggleJFact(Unit_7, 7); break;
     case 7: ToggleJFact(Unit_8, 8); break;
     case 8: ToggleJFact(Unit_9, 9); break;
  };
}

void AstroMenu::unitsslot(int i)
{
  switch(i)
  {
    case 0 : ToggleJRate(Seconds); central->Anim( -1); break;
    case 1 : ToggleJRate(Minutes); central->Anim(-2); break;
    case 2 : ToggleJRate(Hours); central->Anim(-3); break;
    case 3 : ToggleJRate(Days); central->Anim(-4); break;
    case 4 : ToggleJRate(Months); central->Anim(-5); break;
    case 5 : ToggleJRate(Years); central->Anim(-6); break;
    case 6 : ToggleJRate(Decades); central->Anim(-7); break;
    case 7 : ToggleJRate(Centuries); central->Anim(-8); break;
    case 8 : ToggleJRate(Millenia); central->Anim(-9); break;
    default:;
  }
}


