/* 
 *  Copyright (C) 1999 Bernd Gehrmann
 *                     bernd@physik.hu-berlin.de
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the "Artistic License" which comes with this Kit. 
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * Artistic License for more details.
 *
 * You should have received a copy of the Artistic License with 
 * this Kit, in the file named "Artistic".  If not, I'll be glad
 * to provide one.
 */


#include <qregexp.h>
#include <stdlib.h>
#include "misc.h"
#include "sitejob.h"
#include "sitedef.h"


SiteJob::SiteJob(SiteDefinition *site)
{
    m_site = site;
    enableGUI(false);
    state = Begin;

    connect( this, SIGNAL(sigData(int,const char*,int)),
	     SLOT(gotData(int,const char*,int)) );
}


void SiteJob::query(QString searchtext)
{
    QString url = m_site->makeQueryUrl(searchtext);
    cout << "Fetching " << url << endl;
#if 1
    get(url); 
#endif
#if 0
    feedtest("/home/bernd/kdecvs1.1/columbo/colnews/deja.html");
#endif
}


void SiteJob::parseItem(QString item)
{
    int pos1, pos2, pos3;
    QString url, date, subject, forum, author;

#if 0
    cout << "-----------------------------------------------------------" << endl;
    cout << "Parsing Item:" << item << "|" << endl;
    cout << "-----------------------------------------------------------" << endl;
#endif
    
    // This parser sucks.
    pos1 = item.find(m_site->dateStart);
    if (pos1 == -1)
	return;
    
    pos2 = item.find(m_site->dateEnd);
    if (pos2 == -1)
	return;

    pos1 += m_site->dateStart.length();
    date = item.mid(pos1, pos2-pos1);
    item.remove(0, pos2+m_site->dateEnd.length());
    cout << "Datestring: " << date << endl;
    
    pos1 = item.find(m_site->subjectStart);
    if (pos1 == -1)
	return;
    
    pos2 = item.find(m_site->subjectEnd);
    if (pos2 == -1)
	return;

    pos1 += m_site->subjectStart.length();
    subject = item.mid(pos1, pos2-pos1);
    item.remove(0, pos2+m_site->subjectEnd.length());
    cout << "Subjectstring: " << subject << endl;

    pos1 = item.find(m_site->forumStart);
    if (pos1 == -1)
	return;
    
    pos2 = item.find(m_site->forumEnd);
    if (pos2 == -1)
	return;

    pos1 += m_site->forumStart.length();
    forum = item.mid(pos1, pos2-pos1);
    item.remove(0, pos2+m_site->forumEnd.length());
    cout << "Forumstring: " << forum << endl;
    
    pos1 = item.find(m_site->authorStart);
    if (pos1 == -1)
	return;
    
    pos2 = item.find(m_site->authorEnd);
    if (pos2 == -1)
	return;

    pos1 += m_site->authorStart.length();
    author = item.mid(pos1, pos2-pos1);
    item.remove(0, pos2+m_site->authorEnd.length());
    cout << "Authorstring: " << author << endl;

    // Find url inside subject
    cout << "Subjectstring: " << subject << endl;
    pos1 = subject.find(QRegExp("<a href=", false));
    if (pos1 != -1)
	{
	    cout << "Pos1" << pos1 << endl;
	    pos2 = subject.find(">", pos1+8);
	    cout << "Pos2" << pos2 << endl;
	    if (pos2 != -1)
		{
		    pos3 = subject.find(QRegExp("</a>", false), pos2+1);
		    cout << "Pos3" << pos3 << endl;
		    if (pos3 != -1)
			url = subject.mid(pos1+8, pos2-(pos1+8)).stripWhiteSpace();
		    if (url.left(1) == "\"")
			url.remove(0, 1);
		    if (url.right(1) == "\"")
			url.remove(url.length()-1, 1);
		    cout << "Url: " << url << endl;
		}
	}
    
    date = removeHTML(date).stripWhiteSpace();
    subject = removeHTML(subject).stripWhiteSpace();
    forum = removeHTML(forum).stripWhiteSpace();
    author = removeHTML(author).stripWhiteSpace();
    emit foundItem(date, subject, url, forum, author);
}


void SiteJob::gotData(int, const char *data, int len)
{
    int pos, pos1, pos2;
    m_buf += QString(data, len);

    for (;;)
	{
	    switch (state)
		{
		case Begin:
		    if ( (pos = m_buf.find(m_site->resultListStart)) == -1)
			return;
		    cout << "state -> ResultList" << endl;
		    state = ResultList;
		    m_buf.remove(0, pos);
		    break;
		case ResultList:
		    pos1 = m_buf.find(m_site->resultListEnd);
		    pos2 = m_buf.find(m_site->resultItemStart);
		    if (pos1 == -1 && pos2 == -1)
			return;

		    if ( (pos1 != -1) && (pos2 == -1 || pos1 < pos2) )
			{
			    cout << "state -> End" << endl;
			    state = End;
			    return;
			}
		    if (pos2 == -1)
			return;
		    cout << "state -> ResultItem" << endl;
		    state = ResultItem;
		    m_buf.remove(0, pos2);
		    break;
		case ResultItem:
		    if ( (pos = m_buf.find(m_site->resultItemEnd)) == -1)
			return;
		    cout << "state -> ResultList" << endl;
		    state = ResultList;
		    parseItem(m_buf.left(pos));
		    m_buf.remove(0, pos);
		    break;
		default:
		    return;
		}
	}
}

#if 1
void SiteJob::feedtest(QString filename)
{
    char buf[512];
    FILE *f = fopen(filename, "r");
    if (!f)
	return;
    
    while (fgets(buf, sizeof buf, f))
	{
	    QString line = buf;
	    // Feed the data in small chunks so we can see potential problems
	    while (line.length() != 0)
		{
		    int len = QMAX(20, line.length());
		    gotData(0, line.data(), len);
		    line.remove(0, len);
		}
	}
    fclose(f);
}
#endif

// Local Variables:
// c-basic-offset: 4
// End:

















