%{

#include "k2config.parse.h"

void yyerror(char *s);
int yylex();
void initFlex( const char *s );

%}

%union
{
     int vali;
     char *name;
     void *ptr;
     char valb;
     float valf;
}

%token TBOOLEAN
%token TSTRING
%token TLONG
%token TFLOAT
%token TFILE
%token TAG_TRUE
%token TAG_FALSE

%token <name> STRING
%token <vali> NUM
%token <valf> FLOAT

%type <ptr> start
%type <ptr> config
%type <ptr> configs
%type <ptr> items
%type <ptr> item
%type <ptr> strlist
%type <valb> bool
%type <ptr> translation
%type <ptr> titems

/* Grammar follows */
     
%%

start: /* empty */ { setK2ConfigTree( 0L ); }
     | configs { setK2ConfigTree( $<ptr>1 ); }
;

configs: config configs { $$ = addK2ConfigBase( $<ptr>1, $<ptr>2 ); }
      | config { $$ = $<ptr>1; }
;

config: STRING STRING translation '{' '}' ';' { $$ = newK2Config( $<name>1, $<name>2, 0L, $<ptr>3 ); }
     | STRING STRING '{' '}' ';' { $$ = newK2Config( $<name>1, $<name>2, 0L, 0L ); }
     | STRING STRING translation '{' items '}' ';' { $$ = newK2Config( $<name>1, $<name>2, $<ptr>5, $<ptr>3 ); }
     | STRING STRING '{' items '}' ';' { $$ = newK2Config( $<name>1, $<name>2, $<ptr>4, 0L ); }
;

items: item items { $$ = addK2ConfigBase( $<ptr>1, $<ptr>2 ); }
     | config items { $$ = addK2ConfigBase( $<ptr>1, $<ptr>2 ); }
     | item { $$ = $<ptr>1; }
     | config { $$ = $<ptr>1; }
;

item: STRING '<' TSTRING '>' '=' STRING ';' { $$ = newStringK2ConfigItem( $<name>1, $<name>6, 0L ); }
    | STRING '<' TBOOLEAN '>' '=' bool ';' { $$ = newBoolK2ConfigItem( $<name>1, $<valb>6, 0L ); }
    | STRING '<' TLONG '>' '=' NUM ';' { $$ = newLongK2ConfigItem( $<name>1, $<vali>6, 0L ); }
    | STRING '<' TFLOAT '>' '=' FLOAT ';' { $$ = newFloatK2ConfigItem( $<name>1, $<valf>6, 0L ); }
    | STRING '<' TFILE '>' '=' STRING ';' { $$ = newFileK2ConfigItem( $<name>1, $<name>6, 0L ); }
    | STRING '<' '@' TSTRING '>' '=' '{' strlist '}' ';' { $$ = newStringListK2ConfigItem( $<name>1, $<ptr>8, 0L ); }
    | STRING '<' '@' TSTRING '>' '=' '{' '}' ';' { $$ = newStringListK2ConfigItem( $<name>1, 0L, 0L ); }
    | STRING '[' STRING ']' '<' TSTRING '>' '=' STRING ';' { $$ = newStringK2ConfigItem( $<name>1, $<name>9, $<name>3 ); }
    | STRING '[' STRING ']' '<' TBOOLEAN '>' '=' bool ';' { $$ = newBoolK2ConfigItem( $<name>1, $<valb>9, $<name>3 ); }
    | STRING '[' STRING ']' '<' TLONG '>' '=' NUM ';' { $$ = newLongK2ConfigItem( $<name>1, $<vali>9, $<name>3 ); }
    | STRING '[' STRING ']' '<' TFLOAT '>' '=' FLOAT ';' { $$ = newFloatK2ConfigItem( $<name>1, $<valf>9, $<name>3 ); }
    | STRING '[' STRING ']' '<' TFILE '>' '=' STRING ';' { $$ = newFileK2ConfigItem( $<name>1, $<name>9, $<name>3 ); }
    | STRING '[' STRING ']' '<' '@' TSTRING '>' '=' '{' strlist '}' ';' { $$ = newStringListK2ConfigItem( $<name>1, $<ptr>11, $<name>3 ); }
    | STRING '[' STRING ']' '<' '@' TSTRING '>' '=' '{' '}' ';' { $$ = newStringListK2ConfigItem( $<name>1, 0L, $<name>3 ); }
;

strlist: STRING { $$ = newK2ConfigStringList( $<name>1 ); }
       | STRING ',' strlist { $$ = addK2ConfigStringList( $<name>1, $<ptr>3 ); }
;

bool: TAG_TRUE { $$ = 1; }
    | TAG_FALSE { $$ = 0; }
;

translation: '[' titems ']' { $$ = $<ptr>2; }
;

titems: STRING '=' STRING { $$ = newK2ConfigTranslation( $<name>1, $<name>3, 0L ); }
      | STRING '=' STRING ',' titems { $$ = newK2ConfigTranslation( $<name>1, $<name>3, $<ptr>5 ); }
;

/* End of grammar */

%%

void k2configerror ( char *s )  /* Called by yyparse on error */
{
  printf ("ERROR: %s\n", s);
  exit(1);
}

void k2config_mainParse( const char *_code )
{
  k2config_initFlex( _code );
  k2configparse();
}
