/*    e_unix.cpp
 *
 *    Copyright (c) 1997, Marko Macek
 *
 *    You may distribute under the terms of either the GNU General Public
 *    License or the Artistic License, as specified in the README file.
 *
 */

// UNIX specific routines

#include "fte.h"

int EView::SysShowHelp(ExState &State, const char *word) {
    char options[128] = "";
    char command[1024];
    char file[MAXPATH];

    if (State.GetStrParam(this, options, sizeof(options) - 1) == 0)
        options[0] = 0;

    char wordAsk[64] = "";
    if (word == 0) {
        if (State.GetStrParam(this, wordAsk, sizeof(wordAsk) - 1) == 0)
            if (MView->Win->GetStr("Keyword",
                                   sizeof(wordAsk) - 1, wordAsk, HIST_DEFAULT) == 0)
                return 0;
        word = wordAsk;
    }

    sprintf(file, "/tmp/fte%d-man-%s", getpid(), word);
    sprintf(command, "%s %s %s >'%s' 2>&1", HelpCommand, options, word, file);

    int rc = system(command);
        
    if (FileLoad(0, file, "CATBS", this) == 0) {
        unlink(file);
        return 0;
    }
    unlink(file);
    if (rc != 0)
        Msg(ERROR, "Error code %d retrieving manpage for %s", rc, word);
    return 1;
}
