#include "Directories.moc"
#include <qlabel.h>
#include <kapp.h>
#include <klocale.h>
#include <qtooltip.h>

Directories::Directories(QWidget *parent=0, const char *name=0): QWidget(parent,name)
{
	int x=5, y=5;
	int w=640;
	ftpxs=0;
	anonRoot=new InputFileCtl(i18n("Root directory for &anonymous users:"),0,true,0,this);
	anonRoot->setGeometry(x,y,w-10,anonRoot->height());
	y+=anonRoot->height()+5;
	guestRoot=new InputFileCtl(i18n("Root directory for &guest users:"),0,true,i18n("S&elect"),this);
	guestRoot->setGeometry(x,y,w-10,guestRoot->height());
	y+=guestRoot->height()+5;
	passwd=new InputFileCtl(i18n("&Passwd file:"),0,false,i18n("Se&lect"),this);
	passwd->setGeometry(x,y,w-10,passwd->height());
	y+=passwd->height()+5;
	shadow=new InputFileCtl(i18n("&Shadow passwd file:"),0,false,i18n("Sele&ct"),this);
	shadow->setGeometry(x,y,w-10,passwd->height());
}
Directories::~Directories()
{
}
void Directories::ftpaccessLoaded(ftpaccess *xs)
{
	ftpxs=xs;
	anonRoot->setText(ftpxs->getAnonRoot());
	guestRoot->setText(ftpxs->getGuestRoot());
	passwd->setText(ftpxs->getPasswd());
	shadow->setText(ftpxs->getShadow());
}
void Directories::update()
{
	ftpxs->setAnonRoot((char *)anonRoot->text());
	ftpxs->setGuestRoot((char *)guestRoot->text());
	ftpxs->setPasswd((char *)passwd->text());
	ftpxs->setShadow((char *)shadow->text());
}
