#include "prefdlg.h"
#include "pixmaps/linux.xpm"


GeneralWidget::GeneralWidget(QWidget *parent, const char *name):QWidget(parent, name)
{
  GBox = new QGroupBox(this);
  GBox->setGeometry(10, 8, 328, 314);
  GBox->setTitle(klocale->translate("General Setup"));

  prefixlabel = new QLabel(klocale->translate("Prefix:"), this);
  prefixlabel->adjustSize();
  prefixlabel->setGeometry(30, 34, prefixlabel->width(), prefixlabel->height());
  prefix = new QLineEdit(this);
  prefix->setGeometry(140, 30, 110, 24);
  prefix->setMaxLength(PNUMSIZE);

  msnlabel = new QLabel("MSN:", this);
  msnlabel->adjustSize();
  msnlabel->setGeometry(30, 64, msnlabel->width(), msnlabel->height());
  msn = new QLineEdit(this);
  msn->setGeometry(140, 60, 110, 24);
  msn->setMaxLength(PNUMSIZE);

  pmLinux = new QLabel(this);
  pmLinux->setPixmap(linux_xpm);
  pmLinux->setGeometry(276, 40, 33, 36);
    
  AudioGB = new QGroupBox( this );
  AudioGB->setTitle("                  ");
  AudioGB->setGeometry(20, 94, 310, 148);
  
  audiochk = new QCheckBox(klocale->translate("Enable Audio"), this);
  audiochk->adjustSize();
  audiochk->setGeometry(30, 94, audiochk->width(), audiochk->height());
  audiochk->setChecked( false );
  connect(audiochk, SIGNAL(clicked()), SLOT( slotSetEnableAudio()));
  
  connectpathlabel = new QLabel(klocale->translate("Connect Sound:"), this);
  connectpathlabel->adjustSize();
  connectpathlabel->setGeometry(32, 116, connectpathlabel->width(), 24);
  connectpath = new QLineEdit(this);
  connectpath->setGeometry(140, 116, 176, 24);
  connectpath->setMaxLength(PATHSIZE);
  
  browse3 = new QPushButton(klocale->translate("Browse..."), this);
  browse3->setGeometry(242, 146, 74, 24);
  connect(browse3, SIGNAL(clicked()), SLOT(slotBrowseWavConn()));
  
  disconnectpathlabel = new QLabel(klocale->translate("Hangup Sound:"), this);
  disconnectpathlabel->adjustSize();
  disconnectpathlabel->setGeometry(32, 178, disconnectpathlabel->width(), 24);
  disconnectpath = new QLineEdit(this);
  disconnectpath->setGeometry(140, 178, 176, 24);
  disconnectpath->setMaxLength(PATHSIZE);

  browse4 = new QPushButton(klocale->translate("Browse..."), this);
  browse4->setGeometry(242, 208, 74, 26);
  connect(browse4, SIGNAL(clicked()), SLOT(slotBrowseWavDisc()));
    

// Fix this !

  clkchk = new QCheckBox(klocale->translate("Show Clock in Caption"),this);
  clkchk->hide();
/*  clkchk->adjustSize();
  clkchk->setGeometry(30, 252, clkchk->width(), clkchk->height());
  clkchk->setChecked(true);
  clkchk->setEnabled( false );
  connect(clkchk, SIGNAL(clicked()), SLOT(slotShowClockChanged()));
*/
  
  dockchk = new QCheckBox(klocale->translate("Dock on Panel"), this);
  dockchk->adjustSize();
  dockchk->setGeometry(30, 272, dockchk->width(), dockchk->height());
  dockchk->setChecked(false);
  connect(dockchk, SIGNAL(clicked()), SLOT(slotDockChanged()));
  
  shutchk = new QCheckBox(klocale->translate("Disconnect on X Server Shutdown"),this);
  shutchk->adjustSize();
  shutchk->setGeometry(30, 252, shutchk->width(), shutchk->height());
  shutchk->setChecked(true);
  connect(shutchk, SIGNAL(clicked()), SLOT(slotDisconnectChanged()));
  
  advanced = new QPushButton("Advanced...", this);
  advanced->setGeometry(228, 288, 100, 24);
  connect(advanced, SIGNAL(clicked()), SLOT(slotAdvanced()));
  
  refreshSettings();
  slotSetEnableAudio();
}


void GeneralWidget::slotShowClockChanged(void)
{
  ISDNData.setShowClock(clkchk->isChecked());
}



void GeneralWidget::slotDockChanged()
{
  ISDNData.setDocking(dockchk->isChecked());
}


void GeneralWidget::slotDisconnectChanged(void)
{
  ISDNData.setDisconnect(shutchk->isChecked());
}


void GeneralWidget::slotSetEnableAudio()
{
  boolean onOff = audiochk->isChecked();
  connectpathlabel->setEnabled( onOff );
  connectpath->setEnabled( onOff );

  disconnectpathlabel->setEnabled( onOff );
  disconnectpath->setEnabled( onOff );

  browse3->setEnabled( onOff );
  browse4->setEnabled( onOff );

  ISDNData.setAudioChanged( onOff );
}


void GeneralWidget::slotBrowseWavConn()
{
  QFileDialog *Browser = new QFileDialog(kapp->kdedir() + "/share/sounds", "*.wav", this, "", true);
  Browser->setCaption(klocale->translate("Choose Connect-Wave"));

  QString WaveSel;
  
  if (Browser->exec() == QDialog::Accepted) WaveSel = Browser->selectedFile();
  if (!WaveSel.isNull()) 
  {
    connectpath->setText(WaveSel.data());
  }
  
  delete (Browser);
}


void GeneralWidget::slotBrowseWavDisc()
{
  QFileDialog *Browser = new QFileDialog(kapp->kdedir() + "/share/sounds", "*.wav", this, "", true);
  Browser->setCaption(klocale->translate("Choose Disconnect-Wave"));

  QString WaveSel;
  
  if (Browser->exec() == QDialog::Accepted) WaveSel = Browser->selectedFile();
  if (!WaveSel.isNull()) 
  {
    connectpath->setText(WaveSel.data());
  }
  
  delete (Browser);
}


void GeneralWidget::slotAdvanced(void)
{
  AdvData *adv = &((ISDNData.General)->Advanced);
  
  adv->Backup();
  AdvancedDialog *advdialog = new AdvancedDialog();
  bool okpressed = advdialog->exec();
  if (!okpressed) adv->Restore();
  else adv->dbglevel = atoi((advdialog->Debuglevel)->text());
  delete advdialog;
}


void GeneralWidget::refreshSettings(void)
{
  GenData *gen = ISDNData.General;
  
  prefix->setText(gen->prefix.data());
  msn->setText(gen->msn.data());
  connectpath->setText(gen->wavonlinepath.data());
  disconnectpath->setText(gen->wavofflinepath.data());
  clkchk->setChecked(ISDNData.ShowClock());
  dockchk->setChecked(ISDNData.Dock());
  shutchk->setChecked(ISDNData.Disconnect());
  audiochk->setChecked(ISDNData.Audio());
}

