#ifndef __KISDNDATA_H
#define __KISDNDATA_H

#include <stdlib.h>


#define INDXSIZE 2
#define ARGSIZE  64
#define PATHSIZE 128
#define TIMESIZE 8
#define PNUMSIZE 128  /* Phone numbers */
#define DEVSIZE  8    /* Devices       */
#define NAMESIZE 128
#define IPNMSIZE 16   /* IP numbers    */
#define DATMSIZE 2    /* Dial attempts */

#define PAPFILE  "/etc/ppp/pap-secrets"
#define CHAPFILE "/etc/ppp/chap-secrets"
#define DNSFILE  "/etc/resolv.conf"
#define OPTFILE  "/etc/ppp/options"

#define PROTRAWIP  0
#define PROTIP     1
#define PROTCISCO  2
#define PROTETHER  3
#define PROTSYNC   4
#define PROTIPUI   5


class IP
{
  char  data[IPNMSIZE+1];
  bool  isnull;
  
  public:
  
  IP(const char *);
  
  bool isValidIP();
  bool isNull() { return (isnull); } 	/* Don't forget to call isValidIP first ! In case of an   */
};					/* invalid ip the return value of isNull is _undefined_ ! */


class PhoneData
{
  public:
  
  QString    number, tmp_number;
  PhoneData  *prev, *next;
  
  PhoneData();
};


class DNSData
{
  public:
  
  QString  ipaddress, tmp_ipaddress;
  DNSData  *prev, *next;
  
  DNSData();
};


class DevData
{
  public:
  
  PhoneData  *FirstPhone, *LastPhone, *CurrPhone;
  uint       HupTimeout, tmp_HupTimeout;
  ushort     DialAttempts, tmp_DialAttempts;
  uint       Delay, tmp_Delay;
  ushort     Encaps, tmp_Encaps, Layer2, tmp_Layer2, Layer3, tmp_Layer3;
  DevData    *prev, *next;
  QString    Name;
  
  DevData();
  
  void Backup();
  void Restore();
  bool Load(KConfig *, uint, ushort, bool);
  void Save(KConfig *, uint, ushort, bool);
};


class AccData
{
  public:
  
  QString  providername, tmp_providername;
  ushort   device, tmp_device;
  bool     bundle, tmp_bundle;
  DevData  MasterDevice, *FirstSlave, *LastSlave, *CurrDev;
  bool     ipdynamic, tmp_ipdynamic;
  QString  iplocaddress, tmp_iplocaddress, ipremaddress, tmp_ipremaddress;
  QString  subnetmask, tmp_subnetmask;
  QString  domain, tmp_domain;
  DNSData  *FirstDNS, *LastDNS, *CurrDNS;
  bool     UsePAP, tmp_UsePAP, UseCHAP, tmp_UseCHAP;
  QString  username, tmp_username, password, tmp_password;
  AccData  *prev, *next;
  
  AccData();
  
  void Backup();
  void Restore();
  bool Load(KConfig *, uint);
  void Save(KConfig *, uint);
};
  

class AdvData
{
  public:
  
  bool	     bsdcomp, tmp_bsdcomp, incdebug, tmp_incdebug; 
  ushort     dbglevel, tmp_dbglevel;
  
  AdvData();
  
  void Backup();
  void Restore();
  bool Load(KConfig *);
  void Save(KConfig *);
};


class GenData
{
  public:

  QString  ipppdpath, tmp_ipppdpath;
  QString  ctrlpath, tmp_ctrlpath;
  QString  ifconpath, tmp_ifconpath;
  QString  prefix, tmp_prefix, msn, tmp_msn;
  bool     showclock, disconnect, tmp_showclock, tmp_disconnect;
  bool     docking, tmp_docking;
  bool     loadasmodule, tmp_loadasmodule;
  QString  modprobepath, tmp_modprobepath;
  ushort   adapter, tmp_adapter, protocol, tmp_protocol;
  QString  membase, tmp_membase, iobase0, iobase1, tmp_iobase0, tmp_iobase1;
  ushort   interrupt, tmp_interrupt;
  QString  isdnlogpath, tmp_isdnlogpath, isdnreppath, tmp_isdnreppath;
  bool     audioEnabled, tmp_audioEnabled;
  QString  wavonlinepath, tmp_wavonlinepath;
  QString  wavofflinepath, tmp_wavofflinepath;
  AdvData  Advanced, tmp_Advanced;
  
  GenData();
  
  bool	Load(KConfig *);
  void	Save(KConfig *);
  void  Backup();
  void  Restore();
};
  
        
class kISDNData
{
  public:

  uint AccIndex[2];

  GenData  *General;
  AccData  *FirstAccount, *LastAccount, *Current;
  
  kISDNData();
  ~kISDNData();
  
  bool ShowClock() { return (General->showclock); }
  bool Dock() { return (General->docking); }
  bool Disconnect() { return (General->disconnect); }  
  bool Audio() { return (General->audioEnabled); }
  
  void setIpppdPath(const char *path) { General->ipppdpath = *path; }
  void setCtrlPath(const char *path) { General->ctrlpath = *path; }
  void setPrefix(const char *phone) { General->prefix = *phone; }
  void setMsn(const char *phone) { General->msn = *phone; }
  void setShowClock(bool flag) {General->showclock = flag;}
  void setDocking(bool flag) {General->docking = flag;}
  void setDisconnect(bool flag) {General->disconnect = flag;}
  void setAudioChanged(bool flag) {General->audioEnabled = flag;}
  
  bool Load();
  void Save();
  void Backup();
  void Restore();
};


extern kISDNData ISDNData;

#endif
