#include "prefdlg.h"
#include "pixmaps/isdn.xpm"
#include "pixmaps/log.xpm"


LoggingWidget::LoggingWidget(QWidget *parent, const char *name):QWidget(parent, name)
{
  GBox = new QGroupBox(this);
  GBox->setGeometry(10, 8, 328, 314);
  GBox->setTitle(klocale->translate("isdnlog Setup"));

  pmLog = new QLabel(this);
  pmLog->setPixmap(log_xpm);
  pmLog->setGeometry(276, 30, 48 ,48);

  Isdnloglabel = new QLabel(klocale->translate("isdnlog Path:"), this);
  Isdnloglabel->setGeometry(44, 104, 100, 24);
  Isdnlog = new QLineEdit(this);
  Isdnlog->setGeometry(135, 104, 178, 24);
  Isdnlog->setMaxLength(PATHSIZE);
  Isdnlog->setText((ISDNData.General)->isdnlogpath.data());

  Browse1 = new QPushButton(klocale->translate("Browse..."), this);
  Browse1->setGeometry(234, 136, 80, 28);  
  connect(Browse1, SIGNAL(clicked()), SLOT(slotBrowseLogPath()));
  
  Isdnreplabel = new QLabel(klocale->translate("isdnrep Path:"), this);
  Isdnreplabel->setGeometry(44, 178, 100, 24);
  Isdnrep = new QLineEdit(this);
  Isdnrep->setGeometry(135, 178, 178, 24);
  Isdnrep->setMaxLength(PATHSIZE);
  Isdnrep->setText((ISDNData.General)->isdnreppath.data());
 
  Browse2 = new QPushButton(klocale->translate("Browse..."), this);
  Browse2->setGeometry(234, 210, 80, 28);
  connect(Browse2, SIGNAL(clicked()), SLOT(slotBrowseRepPath()));

}


void LoggingWidget::slotBrowseLogPath(void)
{
  QFileDialog *Browser = new QFileDialog("/sbin", "isdnlog", this, "", true);
  Browser->setCaption(klocale->translate("Choose isdnlog Path"));

  QString IsdnlogSel;
  
  if (Browser->exec() == QDialog::Accepted) IsdnlogSel = Browser->selectedFile();
  if (!IsdnlogSel.isNull())
  {
    Isdnlog->setText(IsdnlogSel.data());
    // emit a SIGNAL here ?
  }
  
  delete (Browser);
}


void LoggingWidget::slotBrowseRepPath(void)
{
  QFileDialog *Browser = new QFileDialog("/usr/sbin", "isdnrep", this, "", true);
  Browser->setCaption(klocale->translate("Choose isdnrep Path"));

  QString IsdnrepSel;
  
  if (Browser->exec() == QDialog::Accepted) IsdnrepSel = Browser->selectedFile();
  if (!IsdnrepSel.isNull())
  {
    Isdnrep->setText(IsdnrepSel.data());
    // emit a SIGNAL here ?
  }
  
  delete (Browser);
}


AboutWidget::AboutWidget(QWidget *parent, const char *name):QWidget(parent, name)
{
  GBox = new QGroupBox(this);
  GBox->setGeometry(10, 8, 328, 314);
  GBox->setTitle(klocale->translate("Credits"));
  
  Logo = new QLabel(this);
  Logo->setPixmap(QPixmap(isdn_xpm));
  Logo->setGeometry(75, 50, 200, 60);
  
  Version = new QLabel("kISDN Version 0.3.1", this);
  Version->setGeometry(115, 120, 120, 24);
  
  Authors = new QLabel("Written by:", this);
  Authors->setGeometry(140, 160, 80, 24);
  
  Thorsten = new QLabel("Thorsten Westheider", this);
  Thorsten->setGeometry(115, 184, 120, 24);
  
  Carsten = new QLabel("Carsten Pfeiffer", this);
  Carsten->setGeometry(130, 206, 120, 24);
}
