#ifndef __PREFDLG_H
#define __PREFDLG_H

#include <qdir.h>	/* ...to work against the qfiledlg.h problem... */

#include <kapp.h>
#include <klocale.h>

#include <stdio.h>
#include <ctype.h>

#include <qchkbox.h>
#include <qcombo.h>
#include <qfiledlg.h>
#include <qgrpbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlined.h>
#include <qlistbox.h>
#include <qmsgbox.h>
#include <qpushbt.h>
#include <qradiobt.h>
#include <qtabdlg.h>

#include "logo.h"
#include "mytypes.h"
#include "accdlg.h"
#include "kISDNdata.h"
#include "adapter.h"

#define NEW  1
#define EDIT 2


class AccountWidget : public QWidget
{
  Q_OBJECT
  
  QGroupBox    *GBox;
  QLabel       *costlabel, *pmScreen;
  QLineEdit    *costs;
  QListBox     *acclist;
  QPushButton  *pushedit, *pushnew, *pushcopy, *pushdel, *pushreset;
  QTabDialog   *AccDialog;
  
  DevicesWidget  *DeviceTab;
  IPWidget       *IPTab;
  DNSWidget      *DNSTab;
  AuthWidget     *AuthTab;
  
  int   execAccDialog(ushort);
  
  public:
  
  AccountWidget(QWidget *parent = 0, const char *name = 0); 
   
  private slots:
  
  void slotNewAccount();
  void slotEditAccount();
  void slotCopyAccount();
  void slotDeleteAccount();
};


class AdvancedDialog : public QDialog
{ 
  Q_OBJECT
  
  QGroupBox    *GBox;
  QLabel       *pmMagnify, *Dbglevellabel;
  QPushButton  *Ok, *Cancel;
  
  public:
  
  QCheckBox  *Bsdcheck, *Dbgcheck;
  QLineEdit  *Debuglevel;
 
  AdvancedDialog(QWidget *parent = 0, const char *name = 0);

  private slots:
  
  void slotBSDCompChanged();
  void slotIncDebugChanged();
};


class GeneralWidget : public QWidget
{
  Q_OBJECT
  
  QCheckBox    *clkchk, *shutchk, *dockchk, *audiochk;
  QComboBox    *firstcombo, *secndcombo;
  QGroupBox    *GBox, *AudioGB;
  QLabel       *prefixlabel, *msnlabel, *seclabel;
  QLabel       *pmLinux, *connectpathlabel, *disconnectpathlabel;
  QPushButton  *browse3, *browse4, *advanced;
  
  private slots:
  
  void slotAdvanced();
  void slotShowClockChanged();
  void slotDockChanged();
  void slotSetEnableAudio();
  void slotDisconnectChanged();
  void slotBrowseWavConn();
  void slotBrowseWavDisc();
  
  public:
  
  GeneralWidget(QWidget *parent = 0, const char *name = 0); 
  
  QLineEdit  *prefix, *msn, *connectpath, *disconnectpath;  
 
  void refreshSettings();
};


class CommandWidget : public QWidget
{
  Q_OBJECT
  
  QGroupBox    *GBox;
  QLabel       *pmRoadSign, *ctrlpathlabel, *ipppdpathlabel, *ifconpathlabel;
  QPushButton  *browse1, *browse2, *browse3;
  
  private slots:
  
  void slotBrowseCtrl();
  void slotBrowseIpppd();
  void slotBrowseIfConfig();
  
  public:
  
  CommandWidget(QWidget *parent = 0, const char *name = 0); 

  QLineEdit    *ctrlpath, *ipppdpath, *ifconpath; 

  void refreshSettings(void); 
};


class DriverWidget : public QWidget
{
  Q_OBJECT
  
  QComboBox    *Adbox, *Protobox;
  QGroupBox    *GBox;
  QLabel       *Modprobelabel, *Adapterlabel, *Iolabel, *Intlabel, *Memlabel, *Protlabel, *pmGear;
  QPushButton  *Browse;
  
  Adapter      ad;
  
  void setModState(bool);
  void setParamState();
  void messageBadIO();
  
  public:
  
  DriverWidget(QWidget *parent = 0, const char *name = 0);
  bool isValidIOAddr(ushort);
  bool isValidInterrupt();
  bool isValidMembase();
  void setIOBase(ushort, QString);
  void setInterrupt(char *);
  void setMembase(QString);

  QLineEdit    *Modprobe, *Ioaddr0, *Ioaddr1, *Interrupt, *Membase;
  QCheckBox    *Modulechk;
  
  private slots:
  
  void slotModuleLoadChanged();
  void slotBrowseModPath();
  void slotAdapterChanged(int);
  void slotProtocolChanged(int);
};


class LoggingWidget : public QWidget
{
  Q_OBJECT
  
  QGroupBox    *GBox;
  QLabel       *Isdnloglabel, *Isdnreplabel, *pmLog;
  QPushButton  *Browse1, *Browse2;
  
  public:
  
  LoggingWidget(QWidget *parent = 0, const char *name = 0);

  QLineEdit    *Isdnlog, *Isdnrep;

  private slots:
  
  void slotBrowseLogPath();
  void slotBrowseRepPath();  
};


class AboutWidget : public QWidget
{
  QGroupBox    *GBox;
  QLabel       *Logo, *Version, *Authors, *Thorsten, *Carsten;
  
  public:
  
  AboutWidget(QWidget *parent = 0, const char *name = 0);
};

#endif
