/**********************************************************************

	File: mainwindow.H

	Author:  Sven Schmidt
	Email:   sven.schmidt@cern.ch
	Version: 0.2
	Date:    March 16, 1998

	Description: K Answering Machine (kam) is a frontend for the 
	             vbox package (ISDN answering machine). It displays
		     your voice mail inbox and allows you to play and 
		     delete messages.

 *********************************************************************/

#ifndef mainwindow_H
#define mainwindow_H

#include <qpushbt.h>
#include <qlistbox.h>
#include <qlabel.h>
#include <qlcdnum.h>
#include <qdir.h>
#include <qstrlist.h>
#include <qlist.h>
#include <qfileinf.h>
#include <qdatetm.h>
#include <qfont.h>
#include <qstrlist.h>
#include <qpixmap.h>
#include <qaccel.h>
#include <qmsgbox.h>
#include <qslider.h>
#include <qtimer.h>
#include <qchkbox.h>
#include <qaccel.h>

#include <ktopwidget.h>
#include <ktablistbox.h>
#include <kconfig.h>
#include <kapp.h>
#include <kprocess.h>
 
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "play.H"
#include "config.H"
#include "call.H"




class MainWindow : public KTopLevelWidget {

    Q_OBJECT

public:

  MainWindow();
  virtual ~MainWindow();
  void deleteCall( int id );
  void playCall( int id );
  bool isHidden();

public slots:

  void updateCallList();
  void updateAnswerB();
  void playPressed();
  void stopPressed();
  void deletePressed();
  void quitPressed();
  void configPressed();
  void checkPressed();
  void answerPressed();
  void hidePressed();
  void listDoubleClicked( int index, int column );
  void setVolume( int volume );
  void updateConfig( TConfigData *conf );
  void checkInbox();
  void show();
  void setHidden( bool );
  void showMainWindow();
  void hideMainWindow();
  void highlightNext();
  void highlightPrev();

signals:

  void newCountChanged( int newCount );
  void configUpdated();

protected:

  void         resizeEvent( QResizeEvent * );
  TConfigData  getConfig();
  void         writeConfig();
  QString      stopPath();

private:

  QPushButton   *PlayB;
  QPushButton   *StopB;
  QPushButton   *DeleteB;
  QPushButton   *CheckB;
  QCheckBox     *AnswerB;
  QPushButton   *ConfigB;
  QPushButton   *HideB;
  QPushButton   *QuitB;

  QSlider       *VolumeS;
  QLabel        *VolumeL;

  QList<TCall>  Call;
  QStrList      *CallList;
  KTabListBox   *ListBox;

  QLCDNumber    *NewCountLCD;

  QDir          *InDir;

  TConfigData   ConfData;
  KConfig       *Conf;

  QTimer        *Timer;

  QAccel        *Accel;

  TPlay         *PlayProcess;

  int           NewCount;
  int           Volume;

};




class DockedWindow : public QPushButton {

  Q_OBJECT

public:

  DockedWindow(const char *name = 0);
//
//  void showToolTip();
// 
 
public slots:

//  
//  void slotShowToolTip( QString );

  void  showMenu();
  void  updateMessageCount( int count );
  void  selectQuit();
  void  selectShow();

signals:

  void rightClicked();
  void leftClicked();
  void quitSelected();
  void showSelected();

private:

  //  QLabel  *MessageNumL;
  QPalette    StdPalette;
  QPopupMenu  *Menu;

protected:

  void mousePressEvent( QMouseEvent *event );

};


#endif // mainwindow_H
