#include "kapm.h"

Kapm::Kapm(QWidget*parent,const char* name):QWidget(parent,name){
	// Used to dock the window
	KWM *docker;

	// KAPM is a slop sucker
	nice(10);

	// Make sure that the APM BIOS and kernel driver meet requirements
	checkApm();

	// Self explanitory
	timerEvent(NULL);

	// Build menu
	menu = new QPopupMenu(0, "rclick");
	menu->insertItem("Standby", this, SLOT(slotStandby()));
	menu->insertItem("Suspend", this, SLOT(slotSuspend()));
	menu->insertItem("Power Off", this, SLOT(slotPowerOff()));
	menu->insertSeparator();
	menu->insertItem("APM Status...", this, SLOT(slotAPMStatus()));
	menu->insertItem("About KAPM...", this, SLOT(slotAbout()));	
	menu->insertSeparator();
	menu->insertItem("Quit", this, SLOT(slotQuit()));	

	// Setup timers
	startTimer(60000); // 1 minute interval

	// Dock
	docker = new KWM();
	docker->setDockWindow(this->winId());
  this->setFixedSize(24, 24);

	// Clean up
	delete docker;
}

Kapm::~Kapm(){
}

void Kapm::slotSuspend() {
	changeState( true );
}

void Kapm::slotStandby() {
	changeState( false );
}

void Kapm::slotAPMStatus() {
	QString status;
	QString *status2;

	updateStruct();

  status.sprintf("APM BIOS %d.%d (kernel driver %s)\n",
	               i.apm_version_major, i.apm_version_minor, i.driver_version );

	if (i.apm_flags & 0x10) {
      status.append( "Power Management is currently disabled\n" );
	}
	else {
  		if (i.apm_flags & 0x20) {
      	status.append( "Power Management is currently disengaged\n" );
			
			}
			else {
				status.append( "Power Management is currently enabled\n" );
			};
		};
  status2 = statusString();
	QMessageBox::information(this, "APM Status", status + *status2);
	delete status2;
}

void Kapm::slotAbout() {
	QMessageBox::about(this, "About KAPM", "KAPM 0.1 - A Docking APM Utility For KDE\n1999 Ryan Cumming (Steven_Cumming@BC.Sympatico.Ca)\nPowered by apmlib.c from the apmd distribution");
}

void Kapm::mousePressEvent(QMouseEvent *e) {
	switch (e->button()) {
 		case RightButton: {
    	int x = e->x() + this->x();
    	int y = e->y() + this->y();

    	menu->popup(QPoint(x, y));
    	menu->exec();
			break;
		}
		case MidButton: {
			slotAPMStatus();
      break;
		}
		case LeftButton: {
			timerEvent(NULL);
			break;
		}
	};
}

void Kapm::changeState( bool suspend ) {
   int    fd;

   if ((fd = apm_open()) < 0) {
      errorMsg("Cannot open APM device");
      exit( 1 );
   }
   sync();
   sleep( 2 );
   ioctl( fd, suspend ? APM_IOC_SUSPEND : APM_IOC_STANDBY, NULL );
   ::close( fd );
}

void Kapm::slotPowerOff() {
	execlp("poweroff", NULL);
	QMessageBox::warning(this, "KAPM", "Power off failed. Please upgrade your SysVinit package.");
}

void Kapm::checkApm() {
   switch (apm_exists()) {
   	case 1: errorMsg( "No APM support in kernel" );  exit( 1 );
   	case 2: errorMsg( "Old APM support in kernel" ); exit( 2 );
   }

	 updateStruct();

	 if (!(i.apm_flags & APM_32_BIT_SUPPORT)) {
      errorMsg( "32-bit APM interface not supported" );
      exit( 1 );
   }
}

void Kapm::errorMsg(char *message) {
	QMessageBox::critical(this, "APM Error", message);
}

void Kapm::updateStruct() {
	// Get latest APM status info
     if (apm_read( &i )) {
      errorMsg( "Cannot read APM information" );
      exit( 1 );
   }
}

QString* Kapm::statusString() {
	QString *status;
	char percent[8];
	char time[8];
   switch (i.ac_line_status) {
   	case 0: status = new QString("AC off-line");     			break;
   	case 1: status = new QString("AC on-line");      			break;
   	case 2: status = new QString("On backup power"); 			break;
		default: status = new QString("Unknown power source");break;
   }
   if (i.battery_flags != 0xff
       && i.battery_flags & 0x80) {
      status->append( ", no system battery" );
   } else {
      switch (i.battery_status) {
      	case 0: status->append( ", battery status high" ); break;
      	case 1: status->append( ", battery status low" ); break;
      	case 2: status->append( ", battery status critical" ); break;
      	case 3: status->append( ", battery charging" ); break;
      }
   }
	 if (i.battery_percentage >= 0) {
	 			sprintf((char *)&percent, ": %d%%", i.battery_percentage );
				status->append(percent);
	 }
   if (i.battery_time >= 0) {
	 	    sprintf(time, " (%d %s)", i.battery_time, i.using_minutes ? "min" : "sec" );
				status->append(time);
	 }
	return status;
}

void Kapm::slotQuit() {
	exit(0);
}

void Kapm::timerEvent ( QTimerEvent *e ) {
	bool oldChargeValue;
	bool charging = false;
	QString *status;

	updateStruct();
	status = statusString();
	QToolTip::add( this, status->data() );
	delete status;
	oldChargeValue = charging;
	charging = (i.battery_status == 3);
	if (!charging) {
		drawIcon(i.battery_status);		
	};
	if ((oldChargeValue == false) && (charging == true)) {
		ChargeTimer = new QTimer(this, "ChargeTimer");
		ChargeTimer->start(500); // 1 minute interval
		connect(ChargeTimer, SIGNAL(timeout()), this, SLOT(chargeAnim()));		
		return;
	};
	if ((oldChargeValue == true) && (charging == false)) {
		ChargeTimer->stop();	
		delete ChargeTimer;
	};
  }	

void Kapm::drawIcon(char index) {
	KIconLoader *iconLoader = new KIconLoader();
	QString name;
	QPixmap icon;

	switch (index) {
		case -1: name = "kapm_unknown.xpm"; break;
		case 0: name = "kapm_high.xpm"; break;
		case 1: name = "kapm_low.xpm"; break;
		case 2: name = "kapm_critical.xpm"; break;
		case 3: name = "kapm_empty.xpm"; break;
		default: name = "kapm_high.xpm"; break;
	}

	icon = iconLoader->loadIcon(name, 0, 0);
  setBackgroundPixmap(icon);

	delete iconLoader;
}

void Kapm::chargeAnim() {
	static char currentIndex = 3;
	currentIndex--;
	if (currentIndex < 0) currentIndex = 3;
  drawIcon(currentIndex);
}

















