/***************************************************************************
                          cchoixfichier.h  -  description                              
                             -------------------                                         
    begin                : Thu Jun 3 1999                                           
    copyright            : (C) 1999 by Eric Coquelle                         
    email                : coquelle@hivaoa.unice.fr                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef CCHOIXFICHIER_H
#define CCHOIXFICHIER_H

#include <qwidget.h>
#include <kfiledialog.h>
#include <qdir.h>


class CChoixFichier : public QWidget
{
	Q_OBJECT
public: 
	CChoixFichier(QWidget *parent=0, const char *name=0);
	~CChoixFichier();

	/* Open a dialog and return the file's name */
	const char *OuvreFichier();
	/* Analyse the suffix and set progrcompresseur to: tar, gzip, bzip2, unzip */
	int IdentifieCompresseur();
	/* Return the option for compressing files*/
	const char *getCompresseur();
	/* return the option for uncompressing files */
	const char *getDecompresseur();
	/* return the option for reading archive */
	const char *getListeur();
	/* return the archive's name (with full path) */
	const char *getNomFichier();
	/* return the compressor's name */
	const char *getProgrCompresseur();
	/* Get any special option for the compressor */
	const char *getOptionSupp();
	void initialise();
	/* return the option for adding files to an archive */
	const char* getConcateneur();
	/* Define the archive's name */
	void setNomArchive(QString);
  /** Set the acess path when opening an archive */
  void setCheminAcces(const char* chemin);
  /** return the directory's path of the opened file */
  const char* getCheminAcces();
  /** Define the default path when opening a file
		0: Last dir
		1: home dir
		2: shell's one */
  void setCheminAcces(const char* chemin, int optionOuverture);

private:
	KFileDialog *boitedlg;
	QDir repertoire;
	QString filtre;
	QString fichierchoisit;
	QString progrCompresseur;
	QString compresseur;
	QString decompresseur;
	QString listeur;
	QString compresserconcatener;
	QString optionSupp;
};

#endif





