/***************************************************************************
                          cextraction.cpp  -  description                              
                             -------------------                                         
    begin                : Fri Jun 4 1999                                           
    copyright            : (C) 1999 by Eric Coquelle                         
    email                : coquelle@hivaoa.unice.fr                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "cextraction.h"

CExtraction::CExtraction(QDialog *parent, const char *name ) : QDialog(parent,name,TRUE) {
	QButtonGroup* qtarch_ButtonGroup_1;
	qtarch_ButtonGroup_1 = new QButtonGroup( this, "ButtonGroup_1" );
	qtarch_ButtonGroup_1->setGeometry( 330, 60, 150, 200 );
	qtarch_ButtonGroup_1->setFixedSize( 150, 200 );
	qtarch_ButtonGroup_1->setFocusPolicy( QWidget::NoFocus );
	qtarch_ButtonGroup_1->setBackgroundMode( QWidget::PaletteBackground );
	qtarch_ButtonGroup_1->setFontPropagation( QWidget::NoChildren );
	qtarch_ButtonGroup_1->setPalettePropagation( QWidget::NoChildren );
	qtarch_ButtonGroup_1->setFrameStyle( 49 );
	qtarch_ButtonGroup_1->setLineWidth( 1 );
	qtarch_ButtonGroup_1->setMidLineWidth( 0 );
	qtarch_ButtonGroup_1->QFrame::setMargin( 0 );
	qtarch_ButtonGroup_1->setTitle( i18n("Extract:") );
	qtarch_ButtonGroup_1->setAlignment( 1 );
	qtarch_ButtonGroup_1->setExclusive( FALSE );


	listView = new QListView( this, "ListView_1" );
	listView->setGeometry( 5, 0, 210, 300 );
	listView->setMinimumSize( 0, 0 );
	listView->setMaximumSize( 32767, 32767 );
	listView->setFocusPolicy( QWidget::TabFocus );
	listView->setBackgroundMode( QWidget::PaletteBackground );
	listView->setFontPropagation( QWidget::NoChildren );
	listView->setPalettePropagation( QWidget::NoChildren );
	listView->setFrameStyle( 0 );
	listView->setLineWidth( 1 );
	listView->setMidLineWidth( 0 );
	listView->QFrame::setMargin( 0 );
	listView->setResizePolicy( QScrollView::Manual );
	listView->setVScrollBarMode( QScrollView::Auto );
	listView->setHScrollBarMode( QScrollView::Auto );
	listView->setTreeStepSize( 20 );
	listView->setMultiSelection( FALSE );
	listView->setAllColumnsShowFocus( FALSE );
	listView->setItemMargin( 1 );
	listView->setRootIsDecorated( FALSE );
	listView->addColumn( i18n("Where to extract:"), -1 );
	listView->setColumnWidthMode( 0, QListView::Maximum );
	listView->setColumnAlignment( 0, 1 );

	repertoire=new Directory(listView);
	repertoire->setOpen(TRUE);
	connect(listView, SIGNAL(selectionChanged(QListViewItem*)), this, SLOT(recupere(QListViewItem*)));

	qtarch_LineEdit_1 = new QLineEdit( this, "LineEdit_1" );
	qtarch_LineEdit_1->setGeometry( 330, 10, 150, 30 );
	qtarch_LineEdit_1->setMinimumSize( 0, 0 );
	qtarch_LineEdit_1->setMaximumSize( 32767, 32767 );
	qtarch_LineEdit_1->setFocusPolicy( QWidget::StrongFocus );
	qtarch_LineEdit_1->setBackgroundMode( QWidget::PaletteBase );
	qtarch_LineEdit_1->setFontPropagation( QWidget::NoChildren );
	qtarch_LineEdit_1->setPalettePropagation( QWidget::NoChildren );
	qtarch_LineEdit_1->setText( "" );
	qtarch_LineEdit_1->setMaxLength( 32767 );
	qtarch_LineEdit_1->setFrame( QLineEdit::Normal );
	qtarch_LineEdit_1->setFrame( TRUE );

	QLabel* qtarch_Label_1;
	qtarch_Label_1 = new QLabel( this, "Label_1" );
	qtarch_Label_1->setGeometry( 225, 10, 100, 30 );
	qtarch_Label_1->setMinimumSize( 0, 0 );
	qtarch_Label_1->setMaximumSize( 32767, 32767 );
	qtarch_Label_1->setFocusPolicy( QWidget::NoFocus );
	qtarch_Label_1->setBackgroundMode( QWidget::PaletteBackground );
	qtarch_Label_1->setFontPropagation( QWidget::NoChildren );
	qtarch_Label_1->setPalettePropagation( QWidget::NoChildren );
	qtarch_Label_1->setFrameStyle( 0 );
	qtarch_Label_1->setLineWidth( 1 );
	qtarch_Label_1->setMidLineWidth( 0 );
	qtarch_Label_1->QFrame::setMargin( 0 );
	qtarch_Label_1->setText( i18n("Extract To:") );
	qtarch_Label_1->setAlignment( 289 );
	qtarch_Label_1->setMargin( -1 );


	qtarch_RadioButton_1 = new QRadioButton( this, "RadioButton_1" );
	qtarch_RadioButton_1->setGeometry( 340, 80, 135, 30 );
	qtarch_RadioButton_1->setMinimumSize( 0, 0 );
	qtarch_RadioButton_1->setMaximumSize( 32767, 32767 );
	qtarch_RadioButton_1->setFocusPolicy( QWidget::TabFocus );
	qtarch_RadioButton_1->setBackgroundMode( QWidget::PaletteBackground );
	qtarch_RadioButton_1->setFontPropagation( QWidget::NoChildren );
	qtarch_RadioButton_1->setPalettePropagation( QWidget::NoChildren );
	qtarch_RadioButton_1->setText( i18n("All files") );
	qtarch_RadioButton_1->setAutoRepeat( FALSE );
	qtarch_RadioButton_1->setAutoResize( FALSE );
	qtarch_RadioButton_1->setChecked( TRUE );

	qtarch_RadioButton_2 = new QRadioButton( this, "RadioButton_2" );
	qtarch_RadioButton_2->setGeometry( 340, 150, 135, 30 );
	qtarch_RadioButton_2->setMinimumSize( 0, 0 );
	qtarch_RadioButton_2->setMaximumSize( 32767, 32767 );
	qtarch_RadioButton_2->setFocusPolicy( QWidget::TabFocus );
	qtarch_RadioButton_2->setBackgroundMode( QWidget::PaletteBackground );
	qtarch_RadioButton_2->setFontPropagation( QWidget::NoChildren );
	qtarch_RadioButton_2->setPalettePropagation( QWidget::NoChildren );
	qtarch_RadioButton_2->setText( i18n("Selected files") );
	qtarch_RadioButton_2->setAutoRepeat( FALSE );
	qtarch_RadioButton_2->setAutoResize( FALSE );
	qtarch_RadioButton_2->setChecked( FALSE );

	qtarch_ButtonGroup_1->insert( qtarch_RadioButton_1 );
	qtarch_ButtonGroup_1->insert( qtarch_RadioButton_2 );

	bextraire=new QPushButton(i18n("Extract"), this, "bouton extraction");
  bextraire->setGeometry( 300, 270, 85, 30 );
  bextraire->setFont( QFont( "Times", 18, QFont::Bold ) );
  connect(bextraire, SIGNAL(clicked()), SLOT(FaitExtraction()));	

	QPushButton *bannulle;	
	bannulle=new QPushButton(i18n("Cancel"), this, "bouton annuller");
  bannulle->setGeometry( 400, 270, 85, 30 );
  connect(bannulle, SIGNAL(clicked()), SLOT(PasExtraction()));

	resize( 490,310 );
	setMinimumSize( 0, 0 );
	setMaximumSize( 32767, 32767 );
	chemin="";
}

CExtraction::~CExtraction(){
}

void CExtraction::FaitExtraction()
{
	chemin=qtarch_LineEdit_1->text();
	if(chemin.isEmpty())
		reject();
	accept();	
}

void CExtraction::recupere(QListViewItem *l)
{
	if(l->depth()!=0)
	{
		chemin="/"+chemin;
		chemin=l->text(0)+chemin;
		recupere(l->parent());
	}
	else
	{
		chemin="/"+chemin;
		qtarch_LineEdit_1->setText( chemin );
		chemin="";
	}
}

const char* CExtraction::getCheminAcces()
{
	return (const char*)chemin;
}

int CExtraction::toutExtraire()
{
	if(qtarch_RadioButton_1->isChecked())
		return 0;
	else
		return 1;
}

void CExtraction::PasExtraction()
{
	reject();	
}

void CExtraction::setCheminAcces(const char* chemin, int optionExtraction){
	switch(optionExtraction)
	{
		case 0:
			qtarch_LineEdit_1->setText(chemin);
			break;
		case 1:
			qtarch_LineEdit_1->setText(QDir::homeDirPath());
			break;
		case 2:
			qtarch_LineEdit_1->setText(QDir::currentDirPath());
			break;
	}			
}
