/***************************************************************************
                          FILENAME  -  description                              
                             -------------------                                         
    begin                : Thu Mar  2 20:36:53 CET 2000
    copyright            : (c) 2000 by Eric Coquelle
    email                : coquelle@caramail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef CSCRIPT_H
#define CSCRIPT_H


#include "cwizardstep1.h"
#include "cwizardstep2.h"
#include "cwizardstep3.h"
#include "cwizardstep1patch.h"
#include "cwizardstep1installation.h"
#include "cwizardstep1conversion.h"
#include "cwizardstep1cutt.h"
#include "cwizardstep2install.h"
#include "cwizardstep2conversion.h"
#include "cwizardstep2cutt.h"

/**This class runs a serie of wizards and then
execute the appropriates commands: apply a
patch, install a software (i.e. configure, make ...)
  *@author Eric Coquelle
*/

class CScript {

public: 
	CScript();
	~CScript();

	/* Start the wizard operations)*/
	int demarrerAssistant(const char*, const char*, const char*);
  /** Return the directory where to store the
converted archive */
  const char* getRepertoireConversion();
  /** return the conversion format */
  int getTypeConversion();
	/* Return the directory or file for cutt/uncutt operations.
	Needs to probe a .01 extension */
	const char* getRepertoireCutt();
		
protected: // Protected methods
  /** Let's start patching ! */
  void fairePatch();
  /** show the first wizard */
  int assistantUn();
  /** Show the second wizard */
  /** some useful tips for installation */
  void assistantDeuxInstall();
  /** An installation ? What it is ? */
  void assistantUnInstall();
  /** A patch ? What is it ? */
  void assistantUnPatch();
  /** A conversion ? What for ? */
  int assistantUnConversion();
 /** Parameter conversion ? */
  int assistantDeuxConversion();
  void assistantDeux();
  /** Do installation */
  void faireInstallation();
  /** A split ? What for ? */
  int assistantUnCutt();
  /** What kind of split ? */
  int assistantDeuxCutt();
    	
private: // Private attributes
  /** The third wizard object */
  CWizardStep3 objAssistTrois;
  /** THe second wizard object */
  CWizardStep2 objAssistDeux;
  /** The first wizard object */
  CWizardStep1 objAssistUn;
  /* Addidtional specific wizard */
  CWizardStep1Patch objAssistUnPatch;
  CWizardStep1installation objAssistUnInstall;
  CWizardStep1Conversion objAssistUnConversion;
  CWizardStep1Cutt objAssistUnCutt;
  CWizardStep2install objAssistDeuxInstall;
  CWizardStep2Conversion objAssistDeuxConversion;
  CWizardStep2Cutt objAssistDeuxCutt;
  /* The selected file used for patching */
	const char* fichselect;
	/* Where files are located*/
	const char* repbase;
	/*Current archive name*/
	const char* nomarchive;

private:
  const char* reppatch;
};

#endif
