/*
 * KBatMon - Copyright 1999 Russ Steffen <rsteffen@ia.net>
 *
 * Released under the terms of the GNU General Public License
 *
 *
 * $Id: kbatmonstatus.h,v 1.9 1999/01/15 06:08:49 russ Exp $
 *
 * $Log: kbatmonstatus.h,v $
 * Revision 1.9  1999/01/15 06:08:49  russ
 * Added file headers.
 *
 *
 */
 
#ifndef _KBATMONSTATUS_H_
#define _KBATMONSTATUS_H_

#include <kapp.h>
#include <qdialog.h>

class QPushButton;
class QProgressBar;
class QLabel;
class APMInterface;
class QCheckBox;
class KProgress;
class KBatMonConfig;

class KBatMonStatus : public QWidget
{
    Q_OBJECT

public:
    KBatMonStatus( APMInterface *, KBatMonConfig * );

 protected:
   virtual void keyReleaseEvent( QKeyEvent * );

protected slots:
    void update();

private:
    APMInterface *APM;

    QLabel *batLevelLabel;
    KProgress *batLevel;
    QLabel *timeRemainingLabel;
    QLabel *timeRemaining;
    QLabel *batteryStatus;
    QLabel *powerStatus;

};

#endif /* _KBATMONSTATUS */

