#ifndef KBOOTSELWIDGET_H 
#define KBOOTSELWIDGET_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <qwidget.h>
#include <qstring.h>
#include <qlayout.h>
#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qradiobutton.h>
#include <qtooltip.h>

#include "liloinfo.h"
#include "kbootsel.h"

class KBootSel;

/**
 * This class is the main view for KBootSel.  Most non-menu, non-toolbar,
 * and non-status bar GUI code should go here.
 *
 * @short Main view
 * @author Stefan van den Oord <s.m.vandenoord@student.utwente.nl>
 * @version 0.3
 */
class KBootSelWidget : public QWidget
{
	Q_OBJECT

	public:
		/**
		 * Default constructor
		 * @param lilo The LiloInfo object that is to be used to get the information
		 *             about the contents the widget will have.
		 */
		KBootSelWidget ( LiloInfo *lilo, QWidget *parent = 0, const char *name = 0 );

		/**
		 * Destructor
		 */
		virtual ~KBootSelWidget();

	private:
		friend class KBootSel;

		QVBoxLayout *layout, *lay_buttons;

		QButtonGroup *grp_select;
		QCheckBox *chk_logout;

		QRadioButton *radioList[MAX_OPTIONS];

		KBootSel *mainWindow;

		QStrList *options;

		int liloResult;
		int setupBootOptions ( LiloInfo *lilo );
		int getLiloResult() { return liloResult; }
		int writeNextOption ( LiloInfo *lilo );
		void clearOptions();
};

#endif // KBOOTSELWIDGET_H 
