/***************************************************************************
                          kchmod.cpp  -  description
                             -------------------
    begin                : Thu Jan 13 21:52:54 EST 2000
    copyright            : (C) 2000 by Jonathan Singer
    email                : jsinger@leeta.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software and can be used or redistributed        *
 *   subject to the included license.                                      *
 *                                                                         *
 ***************************************************************************/

#include "kchmod.h"
#include <qkeycode.h>
#include <qdir.h>
#include <stdlib.h>
#include <unistd.h>
#include <qmessagebox.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <stdio.h>
#include "khelpmenu.h"
#include <kconfig.h>
#include <kiconloader.h>
#include <kfiledialog.h>
#include <kcmdlineargs.h>



Kchmod::Kchmod() : KTMainWindow()
{
fileMenu = new KPopupMenu;
QPixmap pixmap;
pixmap = SmallIcon("fileopen");
fileMenu->insertItem( QIconSet(pixmap), i18n("&Open"), this, SLOT(pickFile()), CTRL+Key_O, 0 );
pixmap = SmallIcon("up");
fileMenu->insertItem( QIconSet(pixmap), i18n("Enclosing &Directory"), this, SLOT(useDirectory()), CTRL+Key_D, 1 );
pixmap = SmallIcon("filesave");
fileMenu->insertItem( QIconSet(pixmap), i18n("&Save"), this, SLOT(writeSettings()), CTRL+Key_S, 2 );
fileMenu->insertSeparator();
fileMenu->insertItem( i18n("Show &Tooltips"), this, SLOT(showTooltips()), CTRL+Key_T, 4 );
fileMenu->insertSeparator();
fileMenu->insertItem( i18n("&Quit"), qApp, SLOT(quit()), CTRL+Key_Q, 6 );
menuBar()->insertItem( i18n("&File"), fileMenu, CTRL+Key_F );
KConfig *config = kapp->config();
config->setGroup("Settings");	
show_tips = config->readBoolEntry("Show_Tips",true);
menuBar()->setItemChecked(4, show_tips);
QToolTip::setEnabled(show_tips);
    	
khelp = new KHelpMenu(this, "Kchmod written by Jonathan Singer\n\nCopyright 2000\n\nQuestions, suggestions or flames?\nContact: jsinger@leeta.net\nhttp://www.leeta.net/kchmod/\n", 1);
menuBar()->insertItem( i18n("&Help"), khelp->menu() );

id_val  = 0;
user_val  = 0;
group_val = 0;
other_val = 0;
setuid_set = FALSE;
recursive_set = TRUE;

QString ls_input;
QString fileName;


main_view = new view_w(this);
main_view->setGeometry(0, 0, 360, 270);
setFixedSize(360, 270);
//main_view->setFixedSize(360, 270);
//setGeometry(main_view->geometry());

i_r_button = new QCheckBox(i18n("SetUID"), main_view->id_box, "i_r_button");
i_r_button->setGeometry(8, 10, 58, 13);
i_w_button = new QCheckBox(i18n("SetGID"), main_view->id_box, "i_w_button");
i_w_button->setGeometry(8, 32, 58, 13);
i_x_button = new QCheckBox(i18n("Sticky"), main_view->id_box, "i_x_button");
i_x_button->setGeometry(8, 53, 58, 13);
QToolTip::add(i_r_button,i18n("It's complicated - see What's This?"));
QToolTip::add(i_w_button,i18n("It's complicated - see What's This?"));
QToolTip::add(i_x_button,i18n("It's complicated - see What's This?"));

QWhatsThis::add(i_r_button,i18n("Set the process's effective user ID to that of the file upon execution (called the \"setuid bit\").  No effect on directories."));
QWhatsThis::add(i_w_button,i18n("Set the process's effective group ID to that of the file upon execution (called the \"setgid bit\").  For directories on some systems, put files created in the directory into the same group as the directory, no matter what group the user who creates them is in."));
QWhatsThis::add(i_x_button,i18n("Save the program's text image on the swap device so it will load more quickly when run (called the \"sticky bit\").  For directories on some systems, prevent users from removing files that they do not own in the directory; this is called making the directory \"append-only\"."));

u_r_button = new QCheckBox(i18n("Read"), main_view->user_box, "u_r_button");
u_r_button->setGeometry(9, 10, 50, 13);
u_w_button = new QCheckBox(i18n("Write"), main_view->user_box, "u_w_button");
u_w_button->setGeometry(9, 32, 50, 13);
u_x_button = new QCheckBox(i18n("Exec"), main_view->user_box, "u_x_button");
u_x_button->setGeometry(9, 53, 50, 13);

g_r_button = new QCheckBox(i18n("Read"), main_view->group_box, "g_r_button");
g_r_button->setGeometry(9, 10, 50, 13);
g_w_button = new QCheckBox(i18n("Write"), main_view->group_box, "g_w_button");
g_w_button->setGeometry(9, 32, 50, 13);
g_x_button = new QCheckBox(i18n("Exec"), main_view->group_box, "g_x_button");
g_x_button->setGeometry(9, 53, 50, 13);

o_r_button = new QCheckBox(i18n("Read"), main_view->other_box, "o_r_button");
o_r_button->setGeometry(9, 10, 50, 13);
o_w_button = new QCheckBox(i18n("Write"), main_view->other_box, "o_w_button");
o_w_button->setGeometry(9, 32, 50, 13);
o_x_button = new QCheckBox(i18n("Exec"), main_view->other_box, "o_x_button");
o_x_button->setGeometry(9, 53, 50, 13);

connect( main_view->id_box, SIGNAL(clicked(int)),  SLOT( calculateSettings(int)) );
connect( main_view->user_box, SIGNAL(clicked(int)),  SLOT( calculateSettings(int)) );
connect( main_view->group_box, SIGNAL(clicked(int)),  SLOT( calculateSettings(int)) );
connect( main_view->other_box, SIGNAL(clicked(int)),  SLOT( calculateSettings(int)) );

u_ls= new QLabel(this,"u_ls");
u_ls->setGeometry(120,185,30,30);
u_ls->setMinimumSize(0,0);
u_ls->setFont(QFont("helvetica", 12, 75,true));
u_ls->setText(i18n("---"));

g_ls= new QLabel(this,"g_ls");
g_ls->setGeometry(205,185,30,30);
g_ls->setMinimumSize(0,0);
g_ls->setFont(QFont("helvetica", 12, 75,true));
g_ls->setText(i18n("---"));

o_ls= new QLabel(this,"o_ls");
o_ls->setGeometry(290,185,30,30);
o_ls->setMinimumSize(0,0);
o_ls->setFont(QFont("helvetica", 12, 75,true));
o_ls->setText(i18n("---"));

QToolTip::add(u_ls,i18n("The ls output that will result"));
QToolTip::add(g_ls,i18n("The ls output that will result"));
QToolTip::add(o_ls,i18n("The ls output that will result"));


setButtons();

command= new QLabel(this,"command");
command->setGeometry(10,230,340,30);
command->setMinimumSize(0,0);
command->setFont(QFont("helvetica", 10, 75,true));
command->setText("");


}

Kchmod::~Kchmod()
{
delete fileMenu;
delete khelp;

delete i_r_button;
delete i_w_button;
delete i_x_button;
delete u_r_button;
delete u_w_button;
delete u_x_button;
delete g_r_button;
delete g_w_button;
delete g_x_button;
delete o_r_button;
delete o_w_button;
delete o_x_button;

delete u_ls;
delete g_ls;
delete o_ls;
delete command;
}


void Kchmod::readArgs()
{
/*fileName="/home/jsinger/test";
processFilename();  */

KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
if (args->count())
	{
	fileName = args->arg(0);
	char *path = (char*)fileName.data(); char resolved_path[300];
	realpath(path, resolved_path);
	fileName = resolved_path;

	command->setText(fileName);
	processFilename();
	
	}
}

void Kchmod::pickFile()
{
fileName=KFileDialog::getOpenFileName(QDir::homeDirPath(),
                                                    i18n("*|All files"), this, i18n("Pick A File..."));
processFilename();

}


void Kchmod::processFilename()
{
// Convert fileName to absolute path
//ls selected file
char buffer[300];
sprintf(buffer, "ls -ld %s", fileName.data());
FILE *stream;
if ((stream = popen(buffer, "r")))
{
//write ls of filename to ls_input
fflush(stream);
//fscanf(stream, "%s", ls_input->data());
fscanf(stream, "%s", buffer);
ls_input = QString(buffer);
pclose(stream);
}

//QString none="ls -ld";
if (ls_input.contains("ls -ld"))
	{
	command->setFont(QFont("helvetica", 14, 100,true));
	command->setText(i18n("No such file or directory"));
	command->setFont(QFont("helvetica", 10, 75,true));
	return;
	}
setCaption(fileName);
//parse settings and update values
recursive_set = FALSE; setuid_set = FALSE;
if (ls_input.mid(0,1)=="d") recursive_set = TRUE;

id_val=0;
user_val = 0;
if (ls_input.mid(1,1)=="r") user_val += 4;
if (ls_input.mid(2,1)=="w") user_val += 2;
if (ls_input.mid(3,1)=="x") user_val += 1;
if (ls_input.mid(3,1)=="s")
		{user_val += 1; id_val+=4;}
if (ls_input.mid(3,1)=="S") id_val+=4;

group_val = 0;
if (ls_input.mid(4,1)=="r") group_val += 4;
if (ls_input.mid(5,1)=="w") group_val += 2;
if (ls_input.mid(6,1)=="x") group_val += 1;
if (ls_input.mid(6,1)=="s")
		{group_val += 1; id_val+=2;}
if (ls_input.mid(6,1)=="S") id_val+=2;

other_val = 0;
if (ls_input.mid(7,1)=="r") other_val += 4;
if (ls_input.mid(8,1)=="w") other_val += 2;
if (ls_input.mid(9,1)=="x") other_val += 1;
if (ls_input.mid(9,1)=="t")
		{other_val += 1; id_val+=1;}
if (ls_input.mid(9,1)=="T") id_val+=1;

setButtons();
calculateSettings(0);
command->setText(fileName.data());
//command->setText(resolved_path);
QToolTip::add(command,i18n("The file whose permissions will be changed"));
}

void Kchmod::useDirectory()
{
  if (fileName.length() > 1) // If we're not at /
    {
    if (fileName.right(1) == "/")
    // A directory ending with / was given as an argument
    	{
    	  fileName.truncate(fileName.length()-1);
    	}
    // cut down path to the next /
    while (fileName.right(1) != "/")
    	{
    	  fileName.truncate(fileName.length()-1);
    	}
    processFilename();
    // and then get rid of the trailing /
    fileName.truncate(fileName.length()-1);
  	}
}

void Kchmod::calculateSettings( int id)
{
// read buttons and set values, LCD's and displayed permissions
id_val = 0;
if (i_r_button->isChecked()) id_val += 4;
if (i_w_button->isChecked()) id_val += 2;
if (i_x_button->isChecked()) id_val += 1;

QString setting("---");
user_val = 0;
if (u_r_button->isChecked()) {user_val += 4;  setting.replace(0,1, "r");}
if (u_w_button->isChecked()) {user_val += 2;  setting.replace(1,1, "w");}
if (u_x_button->isChecked()) {user_val += 1;  setting.replace(2,1, "x");}
if (i_r_button->isChecked())
	{
   if (u_x_button->isChecked()) setting.replace(2,1, "s");
   else setting.replace(2,1, "S");
	}

u_ls->setText(setting.data());

setting="---";
group_val = 0;
if (g_r_button->isChecked()) {group_val += 4;  setting.replace(0,1, "r");}
if (g_w_button->isChecked()) {group_val += 2;  setting.replace(1,1, "w");}
if (g_x_button->isChecked()) {group_val += 1;  setting.replace(2,1, "x");}
if (i_w_button->isChecked())
	{
   if (g_x_button->isChecked()) setting.replace(2,1, "s");
   else setting.replace(2,1, "S");
	}
g_ls->setText(setting.data());

setting="---";
other_val = 0;
if (o_r_button->isChecked()) {other_val += 4;  setting.replace(0,1, "r");}
if (o_w_button->isChecked()) {other_val += 2;  setting.replace(1,1, "w");}
if (o_x_button->isChecked()) {other_val += 1;  setting.replace(2,1, "x");}
if (i_x_button->isChecked())
	{
   if (o_x_button->isChecked()) setting.replace(2,1, "t");
   else setting.replace(2,1, "T");
	}
o_ls->setText(setting.data());

recursive_set = FALSE;
if (main_view->recursive->isChecked()) recursive_set = TRUE;
setButtons();

}

void Kchmod::setButtons()
{
i_r_button->setChecked((id_val >> 2) & 1);
i_w_button->setChecked((id_val >> 1) & 1);
i_x_button->setChecked(id_val & 1);
main_view->id_lcd->display(id_val);

u_r_button->setChecked((user_val >> 2) & 1);
u_w_button->setChecked((user_val >> 1) & 1);
u_x_button->setChecked(user_val & 1);
main_view->user_lcd->display(user_val);

g_r_button->setChecked((group_val >> 2) & 1);
g_w_button->setChecked((group_val >> 1) & 1);
g_x_button->setChecked(group_val & 1);
main_view->group_lcd->display(group_val);

o_r_button->setChecked((other_val >> 2) & 1);
o_w_button->setChecked((other_val >> 1) & 1);
o_x_button->setChecked(other_val & 1);
main_view->other_lcd->display(other_val);
main_view->recursive->setChecked(recursive_set);
}

void Kchmod::writeSettings()
{
calculateSettings(0);
char *recursive_flag = "";
if (recursive_set) recursive_flag="-R";


char buffer[300];

sprintf(buffer, "chmod %s %d%d%d%d %s", recursive_flag, id_val, user_val, group_val, other_val, fileName.data());

int result = system(buffer);
command->setText(buffer);
QToolTip::add(command,i18n("The command that was issued"));

if (result == 256) failed();
}

void Kchmod::failed()
{
command->setFont(QFont("helvetica", 14, 100,true));
command->setText(i18n("ERROR!"));
command->setFont(QFont("helvetica", 10, 75,true));
QToolTip::add(command,"");
}

void Kchmod::showTooltips()
{
show_tips = (!show_tips);
menuBar()->setItemChecked(4, show_tips);
QToolTip::setEnabled(show_tips);
KConfig *config = kapp->config();
config->setGroup("Settings");
config->writeEntry("Show_Tips",show_tips);

}