/*
 * pgp2signature.h
 *
 * Copyright (c) 1997 Christian Stueble  stueble@ls6.cs.uni-dortmund.de
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef PGP2SIGNATURE_H
#define PGP2SIGNATURE_H

#include "pgpmpi.h"

#include "pgpsignature.h"
#include "pgptrust.h"

class Pgp2Signature : public PgpSignature
{
public:
    
  Pgp2Signature(QDataStream &source, UINT8 &ctb);
  virtual ~Pgp2Signature();

  void store(QDataStream &dest);

  // returns key-is of key who made this signature
  QString keyId();

  // returns user-id of key who made this signature
  QString userId();

  // returns trust of key who made this signature
  int     getTrust();
  void    setTrust(int new_trust);

protected:
  
  UINT8          CTB;
  UINT32         len;

  UINT8          version;
  UINT8          length;
  UINT8          sigType;
  UINT32         timestamp;
  UINT8          id[8];
  UINT8          concAlgo;
  UINT8          hashAlgo;
  UINT16         testBytes;
  
  PgpMPI         digest;
  PgpTrust       *trust;
};

#endif
