/*
 * pgp2userid.h
 *
 * Copyright (c) 1997 Christian Stueble  stueble@ls6.cs.uni-dortmund.de
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef PGP2USERID_H
#define PGP2USERID_H

#include "pgpuserid.h"
#include "pgptrust.h"

class Pgp2UserId : public PgpUserId
{
public:

  static int MARGINALS_NEEDED;
  static int COMPLETES_NEEDED;

public:
    
  Pgp2UserId(QDataStream &source, UINT8 &ctb);
  Pgp2UserId(const char *name);

  virtual ~Pgp2UserId();

  void       store(QDataStream &dest);
  int        getTrust();

  void       updateTrust();

protected:
  
  UINT8      CTB;
  UINT32     len;
  PgpTrust   *trust;
};

#endif
