/*
 * pgpuserid.cpp
 *
 * Copyright (c) 1997 Christian Stueble  stueble@ls6.cs.uni-dortmund.de
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "pgpsignature.h"
#include "pgpuserid.h"
#include "pgpkey.h"


PgpUserId::PgpUserId() :
  signatureList(new QList<PgpSignature>)
{};

PgpUserId::~PgpUserId()
{};

// adds one userid to this key
void 
PgpUserId::addSignature(PgpSignature *signature, bool first)
{
  if (first)
    signatureList->insert(0, signature);
  else
    signatureList->append(signature);

  updateTrust();
};

bool     
PgpUserId::removeSignature(PgpSignature *signature)
{
  if (signatureList->remove(signature))
    {
      updateTrust();
      return TRUE;
    }
  else
    return FALSE;
};

QString  
PgpUserId::userId()
{
  return name;
}

PgpSignature* 
PgpUserId::signature(int nr)
{
  return signatureList->at(nr);
};

int           
PgpUserId::count()
{
  return signatureList->count();
};
