/****************************************************************************
 * KFileDir - extends QDir and QFile to add facilities to chown and chmod
 *
 *  Copyright (C) 1998 Neil Hart (nhart@magma.ca)
 *
 *  This program is free software; you can redistribute it and/or modify 
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *  $Id: kfiledir.h,v 1.3 1998/04/23 12:00:59 nhart Exp $
 *                                                                   
 ****************************************************************************/

#ifndef __KFILEDIR_H__
#define __KFILEDIR_H__

#include <qdir.h>
#include <qfile.h>
#include <qfileinf.h>

#include <kapp.h>

class KFile : public QFile
{
public:
	KFile() : QFile() {}
	KFile(const char* name) : QFile(name) {}
	KFile(QString name) : QFile((const char *)name) {}
	bool chmod(int mode);
	bool chown(const char* owner, const char* groupname=0);
	bool touch();
};

class KDir : public QDir
{
public:
	KDir() : QDir() {}
	KDir(const char* path, const char* nameFilter=0, int sortSpec = Name|IgnoreCase, int filterSpec=All) : QDir(path, nameFilter, sortSpec, filterSpec) {}
	static bool chmod(const char* dirName, int mode);
	static bool chown(const char* dirName, const char* owner, const char* groupname=0);
};

#endif
