/***************************************************************************
 *
 *  Copyright (C) 1998 Neil Hart (nhart@magma.ca)
 *
 *  This program is free software; you can redistribute it and/or modify 
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  $Id: kprintadd.cpp,v 1.9 1998/05/06 10:18:14 nhart Exp $
 *                                                                   
 ***************************************************************************/

#include "kprintadd.h"
#include <qmsgbox.h>
#include <qfile.h>
#include <qtstream.h>
#include <qstring.h>

#include <iostream.h>
#include <stdio.h>

static char* RCSinfo = "$Id: kprintadd.cpp,v 1.9 1998/05/06 10:18:14 nhart Exp $";

KLocalPrinterDialog::KLocalPrinterDialog ( QWidget* parent,
	const char* name, const char* prName, const char* spool,
	const char* device, int prTypeIdx, const char* note, bool isEditDialog,
	KPrinterApplication* k ) : QDialog ( parent, name, TRUE )
{
	kpa = k;

	if (isEditDialog)
		setCaption( klocale->translate("Edit Selected Local Printer") );
	else
		setCaption( klocale->translate("Add New Local Printer") );

	QLabel* printername = new QLabel( klocale->translate("Names:"), this);
	printername->setGeometry(20, 20, 100, 30 );
	nameEdit = new QLineEdit( this );
	nameEdit->setGeometry(130, 20, 200, 30 );
	nameEdit->setText(prName);
	if ( !isEditDialog )
		connect(nameEdit, SIGNAL(textChanged(const char*)), this,
			SLOT(printerNameChanged(const char*)));

	QLabel* spoolname = new QLabel( klocale->translate("Spool Directory:"),
		this);
	spoolname->setGeometry(20, 60, 100, 30 );
	spoolEdit = new QLineEdit( this );
	spoolEdit->setGeometry( 130, 60, 200, 30 );
	spoolEdit->setText(spool);

	QLabel* devicename = new QLabel( klocale->translate("Printer Device:"),
		this);
	devicename->setGeometry( 20, 100, 100, 30 );
	deviceEdit = new QComboBox( TRUE, this );
	deviceEdit->setGeometry( 130, 100, 200, 30 );
	bool lp0Avail, lp1Avail, lp2Avail;
	kpa->getDeviceAvailability(&lp0Avail, &lp1Avail, &lp2Avail);
	// for edit dialog, default device is the one already set. 
	//  for add dialog, default device is the first one present
	if ( isEditDialog )
	{
		deviceEdit->insertItem( device );
		if ( strncmp( device, "/dev/lp0", 8 ) )
			lp0Avail = false;					// don't insert lp0 again
		if ( strncmp( device, "/dev/lp1", 8 ) )
			lp1Avail = false;
		if ( strncmp( device, "/dev/lp2", 8 ) )
			lp2Avail = false;
	}
	if (lp0Avail)
		deviceEdit->insertItem("/dev/lp0");
	if (lp1Avail)
		deviceEdit->insertItem("/dev/lp1");
	if (lp2Avail)
		deviceEdit->insertItem("/dev/lp2");

	QLabel* printeris = new QLabel( klocale->translate("Printer type:"), this);
	printeris->setGeometry( 20, 140, 100, 30 );
	printerModel = new QListBox(this, "printermodel" );
	printerModel->setGeometry( 20, 180, 310, 100 );
	QString* qsp;
	int i;
	for (i = 0; i < kpa->numberOfPrinterTypes(); i++)
		if ( (kpa->getPrinterGsType(i, &qsp)) )
			printerModel->insertItem( qsp->data() );
	if ( isEditDialog )
		printerModel->setCurrentItem( prTypeIdx );

	QLabel* noteLabel = new QLabel( klocale->translate("Note"), this);
	noteLabel->setGeometry( 20, 290, 100, 30 );
	noteEdit = new QLineEdit( this, "noteedit");
	noteEdit->setGeometry( 130, 290, 200, 30 );
	if ( isEditDialog )
		noteEdit->setText( note );

	
	QPushButton* ok = new QPushButton( klocale->translate("Ok"), this );
	ok->setGeometry( 20, 340, 100, 30 );
	connect( ok, SIGNAL(clicked()), SLOT(okButtonPressed()) );

	QPushButton* cancel = new QPushButton( klocale->translate("Cancel"), this);
	cancel->setGeometry( 130, 340, 100, 30 );
	connect( cancel, SIGNAL(clicked()), SLOT(reject()) );
}

KLocalPrinterDialog::~KLocalPrinterDialog()
{
}

void KLocalPrinterDialog::okButtonPressed()
{
	if (printerModel->currentItem() == -1)
	{
		QMessageBox::information( this, klocale->translate("Add/Edit Printer"),
			klocale->translate("Please select the model of the printer you wish to add") );
		return;
	}
	if ( strcmp(nameEdit->text(), "") == 0)
	{
		QMessageBox::information( this, klocale->translate("Add/Edit Printer"),
			klocale->translate("Please enter a name for the printer") );
		return;
	}
	if ( strcmp(spoolEdit->text(), "") == 0)
	{
		QMessageBox::information( this, klocale->translate("Add/Edit Printer"),
			klocale->translate("Please enter a spool directoryfor the printer") );
		return;
	}
	if ( strcmp(deviceEdit->currentText(), "") == 0)
	{
		QMessageBox::information( this, klocale->translate("Add/Edit Printer"),
			klocale->translate("Please enter a device for the printer") );
		return;
	}
	emit accept();
}

void KLocalPrinterDialog::printerNameChanged(const char* cp)
{
	// strip printer name off spool directory
	QString spool(spoolEdit->text());
	int pos = spool.findRev('/', spool.length());
	spool.truncate(pos + 1);

	// ensure that if multiple names are specified, we only consider the first
	QString prName( cp );
	if ( (pos = prName.find( '|' )) != -1)
		prName.truncate( pos );
	spool += prName;
	spoolEdit->setText(spool.data());
}

const char* KLocalPrinterDialog::printerType()
{
	return printerModel->text(printerModel->currentItem());
}

int KLocalPrinterDialog::printerTypeIndex()
{
	return printerModel->currentItem();
}

const char* KLocalPrinterDialog::printerName()
{
	return nameEdit->text();
}

const char* KLocalPrinterDialog::printerSpool()
{
	return spoolEdit->text();
}

const char* KLocalPrinterDialog::printerDevice()
{
	return deviceEdit->currentText();
}

const char* KLocalPrinterDialog::printerNote()
{
	return noteEdit->text();
}


KRemotePrinterDialog::KRemotePrinterDialog ( QWidget* parent, const char* name,
	const char* prName, const char* spool, const char* host, const char* queue,
	const char* note, bool isEditDialog, KPrinterApplication* k) :
		QDialog ( parent, name, TRUE )
{
	kpa = k;

	if (isEditDialog)
		setCaption( klocale->translate("Edit Selected Remote Printer") );
	else
		setCaption( klocale->translate("Add New Remote Printer") );

	QLabel* printername = new QLabel( klocale->translate("Names:"), this);
	printername->setGeometry(20, 20, 100, 30 );
	nameEdit = new QLineEdit( this );
	nameEdit->setGeometry(130, 20, 200, 30 );
	nameEdit->setText(prName);
	if ( !isEditDialog )
		connect(nameEdit, SIGNAL(textChanged(const char*)), this, SLOT(printerNameChanged(const char*)));

	QLabel* spoolname = new QLabel( klocale->translate("Spool Directory:"), this);
	spoolname->setGeometry(20, 60, 100, 30 );
	spoolEdit = new QLineEdit( this );
	spoolEdit->setGeometry( 130, 60, 200, 30 );
	spoolEdit->setText(spool);

	QLabel* hostname = new QLabel( klocale->translate("Host:"), this);
	hostname->setGeometry( 20, 100, 100, 30 );
	hostEdit = new QLineEdit( this );
	hostEdit->setGeometry( 130, 100, 200, 30 );
	if ( isEditDialog )
		hostEdit->setText( host );

	QLabel* queuename = new QLabel( klocale->translate("Remote Queue:"), this);
	queuename->setGeometry( 20, 140, 100, 30 );
	queueEdit = new QLineEdit( this );
	queueEdit->setGeometry( 130, 140, 200, 30 );
	if ( isEditDialog )
		queueEdit->setText( queue );

	QLabel* noteLabel = new QLabel( klocale->translate("Note"), this);
	noteLabel->setGeometry( 20, 290, 100, 30 );
	noteEdit = new QLineEdit( this, "noteedit");
	noteEdit->setGeometry( 130, 290, 200, 30 );
	if ( isEditDialog )
		noteEdit->setText( note );

	
	QPushButton* ok = new QPushButton( klocale->translate("Ok"), this );
	ok->setGeometry( 20, 340, 100, 30 );
	connect( ok, SIGNAL(clicked()), SLOT(okButtonPressed()) );

	QPushButton* cancel = new QPushButton( klocale->translate("Cancel"), this);
	cancel->setGeometry( 130, 340, 100, 30 );
	connect( cancel, SIGNAL(clicked()), SLOT(reject()) );
}

KRemotePrinterDialog::~KRemotePrinterDialog()
{
}

void KRemotePrinterDialog::okButtonPressed()
{
	if ( strcmp(nameEdit->text(), "") == 0)
	{
		QMessageBox::information( this, klocale->translate("Add/Edit Printer"),
			klocale->translate("Please enter a name for the printer") );
		return;
	}
	if ( strcmp(spoolEdit->text(), "") == 0)
	{
		QMessageBox::information( this, klocale->translate("Add/Edit Printer"),
			klocale->translate("Please enter a spool directory for the printer") );
		return;
	}
	if ( strcmp(hostEdit->text(), "") == 0)
	{
		QMessageBox::information( this, klocale->translate("Add/Edit Printer"),
			klocale->translate("Please enter a remote host name for the printer") );
		return;
	}
	if ( strcmp(queueEdit->text(), "") == 0)
	{
		QMessageBox::information( this, klocale->translate("Add/Edit Printer"),
			klocale->translate("Please enter a remote queue for the printer") );
		return;
	}
	emit accept();
}

void KRemotePrinterDialog::printerNameChanged(const char* cp)
{
	// strip printer name off spool directory
	QString spool(spoolEdit->text());
	int pos = spool.findRev('/', spool.length());
	spool.truncate(pos + 1);

	// ensure that if multiple names are specified, we only consider the first
	QString prName( cp );
	if ( (pos = prName.find( '|' )) != -1)
		prName.truncate( pos );
	spool += prName;
	spoolEdit->setText(spool.data());
}


const char* KRemotePrinterDialog::printerName()
{
	return nameEdit->text();
}

const char* KRemotePrinterDialog::printerNote()
{
	return noteEdit->text();
}

const char* KRemotePrinterDialog::printerHost()
{
	return hostEdit->text();
}

const char* KRemotePrinterDialog::printerQueue()
{
	return queueEdit->text();
}

const char* KRemotePrinterDialog::printerSpool()
{
	return spoolEdit->text();
}

#include "kprintadd.moc"
