#include <qdict.h>

#include "booklayout.h"

extern QDict <TLObj> objDict;

KBookLayout::KBookLayout(TLForm *_parent):KTypeLayout (_parent)
{
}

KBookLayout::~KBookLayout()
{
}

void KBookLayout::end()
{
    int minx=0;
    int miny=0;

    QList <TLObj> *row;
    TLObj *o;

    //find the biggest page
    for (row=rows.first(); row!=0; row=rows.next())
    {
        for ( o=row->first(); o!=0;o=row->next())
        {
            if (minx < o->widget->minimumSize().width())
                minx=o->widget->minimumSize().width();
            if (miny < o->widget->minimumSize().height())
                miny=o->widget->minimumSize().height();
        }
    }
    //now make all pages the same size
    for (row=rows.first(); row!=0; row=rows.next())
    {
        for ( o=row->first(); o!=0;o=row->next())
        {
            o->widget->resize(minx,miny);
        }
    }

    miny+=widget->fontMetrics().height()+16;
    minx+=8;
    widget->setMinimumWidth(minx);
    widget->setMinimumHeight(miny);
    widget->resize(minx,miny);
}