/***************************************************************************
                          kllisttextodevice.h  -  description                              
                             -------------------                                         

    version              : 0.1pre-alpha
    begin                : Fri Feb 26 1999                                           
    copyright            : (C) 1999 by Uwe Bhme                         
    email                : uwe@hof.baynet.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KLISTTEXTODEVICE_H
#define KLISTTEXTODEVICE_H

#include <qlistbox.h>
#include <qstring.h>
#include <qiodevice.h>

/** This class provides behaviour of a sequential QIODevice
  * It can be opened only for writing (therefore the <EM>ODevice</EM>).
  * The main purpouse is to catch text sended to a QTextStream
  * and display the text in a listbox.
  * @author Uwe Bhme
  */

class KListTextODevice :
    public QListBox,
    public QIODevice 
{
    Q_OBJECT

public: 
    KListTextODevice(QWidget *parent=0, const char *name=0);
    ~KListTextODevice();

    /** A call to this is mere cosmeticall. It has no real effect
      * despites you place a opening mode other than <TT>IO_ReadOnly</TT>
      * wich will result to an error.
      */
    bool  open( int );
    /** Closes for receiving of text. Unflushed text will appear in the list.
      * Unflushed text i at maximum the last line.
      */
    void  close();
    /** If there is a unwritten line it will be displayed.
      * <BR>
      * NOTE: Allways there is at maximum one unwritten line.
      */
    void  flush();

    /** Takes a block of text. All lines wich are clearly finished by
      * <TT>'\n'</TT> will be displayed immediatedly.
      */
    int	  readBlock( char *p, uint );
    int	  writeBlock( const char *p, uint );

    uint  size() const;

    int	  getch();
    int	  putch( int );
    int	  ungetch( int );

protected:
    /** Extract all closed and unwritten lines from <EM>hangover</EM> an
      * put it to the list.
      */
    void  out();
    /** Buffer for unfinished textinput. Lines wich are streamed to
      * KListTextODevice and are not yet closed with <TT>'\n'</TT>
      * will remain herein and will be displayed later.
      */
    QString hangover;
};

#endif
