/******************************************************************************
**         File: $RCSfile$
**
**  Description:
**
**      Created: $Date$
**
**      Changes: $Revision$
**   $Log$ 
**
** Distribution: $Name$ 
******************************************************************************/   
#ifndef KDIFFDISPLAY_H
#define KDIFFDISPLAY_H

/*-----------------------------------------------------------------------------
-- SYSTEM INCLUDE FILE DECLARATIONS
-----------------------------------------------------------------------------*/
#include "kdiff.h"

#include <drag.h> 
#include <qwidget.h> 
#include <qscrbar.h>
#include <qpixmap.h>
#include <qmlined.h>
#include <qfontmet.h> 
/*-----------------------------------------------------------------------------
-- PRIVATE INCLUDE FILE DECLARATIONS
-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
-- DEFINITIONS
-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
-- TYPE DEFINITIONS
-----------------------------------------------------------------------------*/
class kdiffDisplay : public QWidget
{
  Q_OBJECT

   public:

     kdiffDisplay ( QWidget* parent=0, const char* name=0 );

     ~kdiffDisplay ();

     void setText( KDiff *kdiff );
     void clearDisplay();
    
     void showLineNr( bool on );
     void setBackColor( const QColor &col );
     void setForeColor( const QColor &col );
     void setInsertColor( const QColor &col );
     void setChangeColor( const QColor &col );
     void setDeleteColor( const QColor &col );
     void setDisplayFont( const QFont &fontCfg );

     void displayPrevDiff();
     void displayNextDiff();
     
     KDiff *diffText;

   public slots:
     void leftHorSbScrolled(int);
     void rightHorSbScrolled(int);
     void vertSbScrolled(int);
     void dropEvent( KDNDDropZone *dropZone );
      

   signals:
     void leftDropAction ( KDNDDropZone* );
     void rightDropAction ( KDNDDropZone* );


   private:
     void drawTextToPixmaps( KDiff *lrText, int startLine, int lines );
     
     KDNDDropZone *diffDropZone;
     
     QPixmap *leftTextPi, *rightTextPi;
     QRect leftTextRe, rightTextRe;
     
     QScrollBar *leftHorSb, *rightHorSb, *vertSb;

     QColor backCo, foreCo, deleteCo, changeCo, insertCo;

     QFont drawTextFn;
     QFontMetrics *drawTextMt;

     int maxLeftLineLenght;
     int maxRightLineLenght;
     int lineCount;
     int topLineNr;
     int visibleLines;
     int visibleChars;
      
     bool showFLines;
   protected:
     virtual void paintEvent(QPaintEvent *pe );
     virtual void resizeEvent(QResizeEvent *re );


}; // End of Class kdiffDisplay

#endif
