/*
	cattree.h - part of KDiskCat the KDE Disk Catalog.

	Copyright (c) 1998,1999 Balzs Ternyi <terenyi@freemail.c3.hu>

	KDiskCat is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
			
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
					
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef CATTREE_H
#define CATTREE_H

#include <qpushbutton.h>
#include <ktreelist.h>
#include <knewpanner.h>
#include <ktablistbox.h>
#include <kiconloader.h>

#include "cathandler.h"
#include "ektreelist.h"
#include "prefs.h"

class CatView : public KNewPanner
{
   Q_OBJECT
public:
   CatView(QWidget *parent=0,const char *name=0,Orientation orient=Vertical,Units units=Percent,int pos=50);
   ~CatView();
   void init();
   void refreshTree();
   void refreshList(KPath selected_item);
   QString sizeToString(uint size);
	void gotoSelected(QString category,KPath branch,QString filename);
   KPath visible_branch;
public slots:
   void slotSave();
   void slotCategoryChoice(int index);
   void slotOpen();
   void refreshAll();
   void slotProperties();
   void slotDelCategory();
   void slotRenameCategory();
   void slotDeleteCatalog();
	void slotRenameCatalog();
	void slotMoveCatalog();
	void slotMove();
	void slotNew();
	void slotNewCategory();
	void slotExportCategory();
protected slots:
   void slotTreeSelection(int index);
   void slotListClicked(int index,int);
   void slotListSelection(int index,int);
   void slotTreePopup(int index);
   void slotListPopup(int index);
signals:
   void categoriesChanged(QStrList *cats);
   void comboSelectionRequired(QString* name);
private:
   eKTreeList* cattree;
   KTabListBox* catlist;
   QPixmap folder_xpm;
   QPixmap catalog_xpm;
   KIconLoader* icon_loader;
};

#endif
