/*
	PropertiesDlgData.cpp - part of KDiskCat the KDE Disk Catalog.

	Copyright (c) 1998,1999 Balzs Ternyi <terenyi@freemail.c3.hu>

	KDiskCat is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
			
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
					
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <kapp.h>
#include "PropertiesDlgData.h"

#define Inherited QDialog


PropertiesDlgData::PropertiesDlgData
(
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name, TRUE )
{
	lb_fname_lb = new QLabel( this, "lb_fname_lb" );
	lb_fname_lb->setText(i18n("Filename:"));
	lb_fname_lb->setAlignment( 289 );
	lb_fname_lb->setMargin( -1 );

	lb_location_lb = new QLabel( this, "lb_location_lb" );
	lb_location_lb->setText(i18n("Location:"));
	lb_location_lb->setAlignment( 289 );
	lb_location_lb->setMargin( -1 );

	lb_size_lb = new QLabel( this, "lb_size_lb" );
	lb_size_lb->setText(i18n("Size:"));
	lb_size_lb->setAlignment( 289 );
	lb_size_lb->setMargin( -1 );

	lb_date_lb = new QLabel( this, "lb_date_lb" );
	lb_date_lb->setText(i18n("Date:"));
	lb_date_lb->setAlignment( 289 );
	lb_date_lb->setMargin( -1 );

	lb_filename = new QLabel( this, "lb_filename" );
	lb_filename->setFrameStyle( 50 );
	lb_filename->setAlignment( 289 );
	lb_filename->setMargin( -1 );

	lb_location = new QLabel( this, "lb_location" );
	lb_location->setFrameStyle( 50 );
	lb_location->setAlignment( 289 );
	lb_location->setMargin( -1 );

	lb_size = new QLabel( this, "lb_size" );
	lb_size->setFrameStyle( 50 );
	lb_size->setAlignment( 289 );
	lb_size->setMargin( -1 );

	lb_date = new QLabel( this, "lb_date" );
	lb_date->setFrameStyle( 50 );
	lb_date->setAlignment( 289 );
	lb_date->setMargin( -1 );

	lb_description = new QLabel( this, "lb_description" );
	lb_description->setText(i18n("Description:"));
	lb_description->setAlignment( 289 );
	lb_description->setMargin( -1 );

	mle_description = new QMultiLineEdit( this, "mle_description" );
	mle_description->insertLine( "" );
	mle_description->setReadOnly( FALSE );
	mle_description->setOverwriteMode( FALSE );


	pb_ok = new QPushButton( this, "pb_ok" );
	pb_ok->setText(i18n("Ok"));
	pb_ok->setAutoRepeat( FALSE );
	pb_ok->setAutoDefault( TRUE );

	pb_cancel = new QPushButton( this, "pb_cancel" );
	pb_cancel->setText(i18n("Cancel"));
	pb_cancel->setAutoRepeat( FALSE );

	resize(1, 1);
	setMinimumSize(400,300); // repaint
}


PropertiesDlgData::~PropertiesDlgData()
{
}


void PropertiesDlgData::resizeEvent(QResizeEvent *)
{
	int width1, width2, width3, width4, maxwidth;

	width1 = lb_fname_lb   ->fontMetrics().width(lb_fname_lb   ->text());
	width2 = lb_location_lb->fontMetrics().width(lb_location_lb->text());
	width3 = lb_size_lb    ->fontMetrics().width(lb_size_lb    ->text());
	width4 = lb_date_lb    ->fontMetrics().width(lb_date_lb    ->text());

	lb_fname_lb   ->setGeometry( 10,  5, width1, 30 );
	lb_location_lb->setGeometry( 10, 35, width2, 30 );
	lb_size_lb    ->setGeometry( 10, 65, width3, 30 );
	lb_date_lb    ->setGeometry( 10, 95, width4, 30 );

	maxwidth = width1;
	if (maxwidth < width2) maxwidth = width2;
	if (maxwidth < width3) maxwidth = width3;
	if (maxwidth < width4) maxwidth = width4;

	lb_filename->setGeometry( maxwidth+20,  10, width()-maxwidth-30, 25 );
	lb_location->setGeometry( maxwidth+20,  40, width()-maxwidth-30, 25 );
	lb_size    ->setGeometry( maxwidth+20,  70, width()-maxwidth-30, 25 );
	lb_date    ->setGeometry( maxwidth+20, 100, width()-maxwidth-30, 25 );

	lb_description ->setGeometry( 10, 130, width()-20, 30 );
	mle_description->setGeometry( 10, 160, width()-20, height()-210 );

	width1 = pb_ok    ->fontMetrics().width(pb_ok    ->text());
	width2 = pb_cancel->fontMetrics().width(pb_cancel->text());
	if (width1 < width2) maxwidth = width2; else maxwidth = width1;
	maxwidth += 20;

	pb_ok    ->setGeometry( width()/2-20-maxwidth, height()-40, maxwidth, 30 );
	pb_cancel->setGeometry( width()/2+20,          height()-40, maxwidth, 30 );
}
