/*
	kdiskcat.h - part of KDiskCat the KDE Disk Catalog.

	Copyright (c) 1998,1999 Balzs Ternyi <terenyi@freemail.c3.hu>

	KDiskCat is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
			
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
					
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef KDISKCAT_H
#define KDISKCAT_H 
 
#include <kapp.h>
#include <ktmainwindow.h> 
#include <kfiledialog.h>
#include <kaccel.h>
#include <kiconloader.h>

#include "cattree.h"
#include "prefs.h"

class Kdiskcat : public KTMainWindow { 
  Q_OBJECT 
public: 
  Kdiskcat(); 
  ~Kdiskcat();
  void init();  
  void initMenu(); 
  void initToolbar();
  void initStatusBar(); 
  
  void readSettings();
  void writeSettings();

  void gotoSelected(QString category,KPath branch,QString filename);
  
  enum {STATUSBAR_TEXT,STATUSBAR_MOD,STATUSBAR_DISK};
protected:
//  void saveData(KConfig* sessionConfig);
  virtual void closeEvent(QCloseEvent* e);

protected slots: 
  void slotQuit();
  void slotSummary();
  void slotPluginConfig();
  void slotPreferences();
  void slotSearch();
  void slotViewTToolbar();
  void slotViewTStatusbar();

  void slotToolbarClicked(int item);
  void slotRefreshCategoryCombo(QStrList * cats);
  void slotCategoryChoice(int index);
  int slotSelectComboItem(QString* str);
private:
  CatView* view;
  enum {TOOLBAR_CATEGORY,TOOLBAR_NEW,TOOLBAR_SAVE,TOOLBAR_QUIT,TOOLBAR_PROP,TOOLBAR_SEARCH,TOOLBAR_OPEN};
  KConfig *config;
};

#endif